/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xslt.XSLStylesheet;

public class LineTable {
    private static final int SIZE = 100;
    private int classID = -1;
    private int methodID = -1;
    private XSLStylesheet xss;
    private long start = -1L;
    private long end = -1L;
    private int startLine = -1;
    private int endLine = -1;
    private int lines = 0;
    private int lastVisitedLine = -1;
    private long[] lineCodeIndex;
    private int[] lineNumber;
    private int pos;
    private int size;

    public LineTable(int n, int n2, XSLStylesheet xSLStylesheet) {
        this.classID = n;
        this.methodID = n2;
        this.xss = xSLStylesheet;
        this.lineCodeIndex = new long[100];
        this.lineNumber = new int[100];
        this.pos = 0;
        this.size = 100;
    }

    public LineTable(int n, int n2, int n3, int n4) {
        this.classID = n;
        this.methodID = n2;
        this.start = n3;
        this.startLine = n3;
        this.end = n4;
        this.endLine = n4;
        this.lines = n4 - n3 + 1;
        this.lineCodeIndex = new long[this.lines];
        this.lineNumber = new int[this.lines];
        for (int i = n3; i <= n4; ++i) {
            int n5 = i - n3;
            this.lineNumber[n5] = i;
            this.lineCodeIndex[n5] = i;
        }
    }

    int getClassID() {
        return this.classID;
    }

    int getMethodID() {
        return this.methodID;
    }

    void setMethodID(int n) {
        this.methodID = n;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int getLines() {
        return this.lines;
    }

    public long[] getLineCodeIndex() {
        return this.lineCodeIndex;
    }

    public int[] getLineNumber() {
        return this.lineNumber;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setStartLine(int n) {
        this.startLine = n;
    }

    public void setEndLine(int n) {
        this.endLine = n;
    }

    public void setCodeIndexLineNumber(long l, int n) {
        if (this.pos + 1 == this.size) {
            this.size *= 2;
            long[] lArray = this.lineCodeIndex;
            int[] nArray = this.lineNumber;
            this.lineCodeIndex = new long[this.size];
            this.lineNumber = new int[this.size];
            System.arraycopy(lArray, 0, this.lineCodeIndex, 0, this.size / 2);
            System.arraycopy(nArray, 0, this.lineNumber, 0, this.size / 2);
        }
        this.lineCodeIndex[this.pos] = l;
        this.lineNumber[this.pos++] = n;
        this.lastVisitedLine = n;
    }

    public int getLastVisitedLine() {
        return this.lastVisitedLine;
    }

    public void notifyEnd() {
        this.lines = this.calculateLines();
        this.deleteEmptySpots(this.lineCodeIndex, this.lineNumber);
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "LineTable: " + this.classID + ":" + this.methodID + ":" + this.start + ":" + this.end + ":" + this.lines);
        for (int i = 0; i < this.lines; ++i) {
            XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), this.lineNumber[i] + ":" + this.lineCodeIndex[i]);
        }
        this.xss.getJDWPMethod().makeLineTable(this);
    }

    private int calculateLines() {
        return this.endLine - this.startLine + 1;
    }

    private void deleteEmptySpots(long[] lArray, int[] nArray) {
        if (this.lines == this.pos) {
            return;
        }
        long[] lArray2 = new long[this.pos];
        int[] nArray2 = new int[this.pos];
        System.arraycopy(this.lineCodeIndex, 0, lArray2, 0, this.pos);
        System.arraycopy(this.lineNumber, 0, nArray2, 0, this.pos);
        this.lineCodeIndex = lArray2;
        this.lineNumber = nArray2;
        this.lines = this.pos;
    }
}

