/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.IOException;
import java.util.Stack;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.util.XMLUtil;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIContentManager;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class XTIEncoder
extends XTIContentManager
implements ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
XTIConstants {
    private Stack<ParentFChild> parentFChild = new Stack();
    private int previousXTINAddress = 0;
    private String xmlversion = null;
    private String standalone = null;
    private Locator locator = null;

    XTIEncoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
        this.err = new XMLError();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        System.arraycopy(cArray, n, this.charBuffer, this.charLength, n2);
        this.charLength += n2;
    }

    @Override
    void unsetIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2, true);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by & 0xEF);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    private int getFirstChildInParentStack() {
        int n = this.parentFChild.size();
        if (n == 0) {
            return 0;
        }
        for (int i = n - 1; i >= 0; --i) {
            ParentFChild parentFChild = (ParentFChild)this.parentFChild.get(i);
            if (parentFChild.getParent() != this.curParentAddress) continue;
            return parentFChild.getFirstChild();
        }
        return -1;
    }

    private void updateParentFirstChild(int n) {
        if (n == 0) {
            return;
        }
        for (int i = this.parentFChild.size() - 1; i >= 0; --i) {
            int n2;
            ParentFChild parentFChild = (ParentFChild)this.parentFChild.get(i);
            if (parentFChild.getParent() != this.curParentAddress || (n2 = parentFChild.getFirstChild()) != -1) continue;
            parentFChild.setFirstChild(n);
            break;
        }
    }

    private byte[] packXTINBytes12To27(byte[] byArray) throws SAXException {
        int n;
        this.currentXTINAddress = this.getXTINAddress();
        this.updateParentFirstChild(this.currentXTINAddress);
        this.updateLastFirst4XTINLink(this.getFirstChildInParentStack(), this.currentXTINAddress);
        if (this.previousXTINAddress == 0 && this.parentFChild.size() != 0) {
            this.updateChildForXTIN(this.currentXTINAddress);
        }
        byte[] byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[16 + n] = byArray2[n];
        }
        if (this.parentFChild.size() != 0) {
            n = this.parentFChild.peek().getParent();
            byArray2 = XTIUtil.intToByteArray(n);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[20 + i] = byArray2[i];
            }
        }
        if (this.previousXTINAddress != 0) {
            this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
        } else {
            this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
        }
        return byArray;
    }

    private void flushCharacters() throws SAXException {
        try {
            int n;
            byte[] byArray = new byte[32];
            byArray[0] = this.cdata ? 4 : 3;
            this.xticmode = 2;
            String string = new String(this.charBuffer, 0, this.charLength);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = this.currentXTINAddress;
            this.charLength = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int n;
        if (this.xtiStream.isInterleaving()) {
            this.compression = (byte)(this.compression | 9);
        }
        this.xtinRootPageHeader[0] = (byte)(0x10 | this.compression);
        this.xtinRootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
        byte[] byArray = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (n = 0; n < byArray.length; ++n) {
            this.xtinRootPageHeader[4 + n] = byArray[n];
        }
        if (this.xtinSchemaHeaderFlag != 0) {
            this.xtinRootPageHeader[17] = this.xtinSchemaHeaderFlag;
            if (this.xmlencoding != null) {
                n = this.xmlencoding.length();
                int[] nArray = this.getXTICTextAddress(++n);
                byArray = XTIUtil.intToByteArray(nArray[0]);
                for (int i = 0; i < 4; ++i) {
                    this.xtinRootPageHeader[13 + i] = byArray[i];
                }
                this.xtiStream.writeTextToAddress(nArray, this.xmlencoding);
            }
        }
        this.xtiStream.setXTINPageNumber(0, this.xtinRootPageHeader);
        this.xticRootPageHeader = this.xtiStream.getXTICPageNumber(0, true);
        this.xticRootPageHeader[0] = 1;
        byArray = XTIUtil.shortToByteArray(this.freeBytesQname);
        this.xticRootPageHeader[2] = byArray[0];
        this.xticRootPageHeader[3] = byArray[1];
        byArray = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[4 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.freeBytesText);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[8 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastTextPage);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[12 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[16 + n] = byArray[n];
        }
        this.xtiStream.setXTICPageNumber(0, this.xticRootPageHeader);
        try {
            this.xtiStream.flushToStream();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.previousXTINAddress = this.parentFChild.pop().getParent();
        this.curParentAddress = this.parentFChild.peek().getParent();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            int n;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            this.xticmode = 2;
            int[] nArray = new int[]{this.getXTICTextAddress(this.getUTF8BytesSize(string2))[0], this.getXTICTextAddress(this.getUTF8BytesSize(string))[0]};
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlversion = ((Locator2)this.locator).getXMLVersion();
                if (this.xmlversion != null && this.xmlversion.length() > 0) {
                    this.compression = (byte)(this.compression | 4);
                    this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 1);
                }
                if (this.locator instanceof XMLLocator) {
                    if (this.xmlencoding == null) {
                        this.xmlencoding = ((XMLLocator)this.locator).getDeclEncoding();
                        if (this.xmlencoding != null && this.xmlencoding.length() > 0) {
                            this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 2);
                        }
                    }
                    if (this.standalone == null) {
                        this.standalone = ((XMLLocator)this.locator).getStandalone();
                        if (this.standalone != null && this.standalone.length() > 0) {
                            if (this.standalone.equals("yes")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 8);
                            } else if (this.standalone.equals("no")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 4);
                            }
                        }
                    }
                }
            }
            this.xtinRootPageHeader = this.xtiStream.getXTINPageNumber(0, true);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.getFirstChildInParentStack(), this.currentXTINAddress);
            this.parentFChild.push(new ParentFChild(this.currentXTINAddress, -1));
            this.curParentAddress = this.parentFChild.peek().getParent();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string3), string2, string3);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray = this.packXTINBytes12To27(byArray);
            n = this.updateAttributeNode(attributes);
            byArray2 = XTIUtil.intToByteArray(n);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[28 + i] = byArray2[i];
            }
            this.parentFChild.push(new ParentFChild(this.currentXTINAddress, -1));
            this.curParentAddress = this.parentFChild.peek().getParent();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private int updateAttributeNode(Attributes attributes) throws XTIException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                int n4;
                n3 = n2;
                n2 = this.getXTINAddress();
                if (i == 0) {
                    n = n2;
                }
                byArray = new byte[32];
                byArray[0] = 2;
                byte[] byArray2 = this.getQNameAddress(attributes.getURI(i), XMLUtil.getPrefix(attributes.getQName(i)), attributes.getLocalName(i), attributes.getQName(i));
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray[4 + j] = byArray2[j];
                }
                this.xticmode = 2;
                int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(attributes.getValue(i)));
                this.xtiStream.writeTextToAddress(nArray, attributes.getValue(i));
                byArray2 = XTIUtil.intToByteArray(nArray[0]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[16 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[12 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(this.currentXTINAddress);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[20 + n4] = byArray2[n4];
                }
                if (i != 0) {
                    this.updateNextAttributeForXTIN(n3, n2);
                }
                if (XMLUtil.getPrefix(attributes.getQName(i)).equals("xmlns")) {
                    byArray[29] = 2;
                } else if (XMLUtil.getPrefix(attributes.getQName(i)).length() == 0 && attributes.getLocalName(i).equals("xmlns")) {
                    byArray[29] = 4;
                }
                this.xtiStream.writeToXTINAddress(n2, byArray, false);
            }
            return n;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void updateNextAttributeForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4, true);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateLastFirst4XTINLink(int n, int n2) {
        if (n == 0) {
            n = n2;
        }
        int n3 = n2 & 0xFF;
        int n4 = (n2 & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4, true);
        int n5 = n3 * 32 + 24;
        byArray[n5] = (byte)(n >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n >>> 0 & 0xFF);
        int n6 = n & 0xFF;
        int n7 = (n & 0x7FFFFF00) >>> 8;
        int n8 = n6 * 32 + 16;
        if (n4 == n7) {
            byArray[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n4, byArray);
        } else {
            this.xtiStream.setXTINPageNumber(n4, byArray);
            byte[] byArray2 = this.xtiStream.getXTINPageNumber(n7, true);
            byArray2[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray2[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray2[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray2[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n7, byArray2);
        }
    }

    private void updatePreviousForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 16;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4, true);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateNextForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4, true);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
        if (n != n2 && n != 0) {
            this.unsetIsLastChildFlag(n);
        }
    }

    private void updateChildForXTIN(int n) {
        int n2 = this.parentFChild.peek().getParent() & 0xFF;
        int n3 = (this.parentFChild.peek().getParent() & 0x7FFFFF00) >>> 8;
        int n4 = n2 * 32 + 12;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n3, true);
        byArray[n4] = (byte)(n >>> 24 & 0xFF);
        byArray[n4 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n4 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n4 + 3] = (byte)(n >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n3, byArray);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 8;
            this.xticmode = 2;
            String string = new String(cArray, n, n2);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[8 + n3] = byArray2[n3];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[4 + n3] = byArray2[n3];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = false;
    }

    @Override
    public void endDTD() throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void endEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = true;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    private void loadPage(int n, int n2) {
        if (n == 0) {
            this.xtiStream.readXTINPage(n2, true);
        } else if (n == 1) {
            this.xtiStream.readXTICPage(n2, true);
        }
    }

    class ParentFChild {
        int iparent;
        int ifchild;

        ParentFChild(int n, int n2) {
            this.iparent = n;
            this.ifchild = n2;
        }

        void setParent(int n) {
            this.iparent = n;
        }

        void setFirstChild(int n) {
            this.ifchild = n;
        }

        int getParent() {
            return this.iparent;
        }

        int getFirstChild() {
            return this.ifchild;
        }
    }
}

