/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SAXParser
extends XMLParser
implements XMLReader,
Parser {
    private ContentHandler cntHandler;
    static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    static final String DECL_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    public static final String REPORT_CHARS_CHUNKS = "oracle.xml.parser.SAXParser.CharChunks";
    private static final boolean charChunksProperty;
    private static final String SAX_FEATURE_PREFIX = "http://xml.org/sax/features/";
    static final String SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    static final String SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    static final String SAX_FEATURE_IS_STANDALONE = "http://xml.org/sax/features/is-standalone";
    static final String SAX_FEATURE_LEXICAL_HANDLER_PARAMETER_ENTITITES = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    static final String SAX_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    static final String SAX_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String SAX_FEATURE_RESOLVE_DTD_URIS = "http://xml.org/sax/features/resolve-dtd-uris";
    static final String SAX_FEATURE_STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    static final String SAX_FEATURE_UNICODE_NORMALIZATION_CHECKING = "http://xml.org/sax/features/unicode-normalization-checking";
    static final String SAX_FEATURE_USE_ATTRIBUTES2 = "http://xml.org/sax/features/use-attributes2";
    static final String SAX_FEATURE_USE_LOCATOR2 = "http://xml.org/sax/features/use-locator2";
    static final String SAX_FEATURE_USE_ENTITY_RESOLVER2 = "http://xml.org/sax/features/use-entity-resolver2";
    static final String SAX_FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    static final String SAX_FEATURE_XMLNS_URIS = "http://xml.org/sax/features/xmlns-uris";
    static final String SAX_FEATURE_XML_1_1 = "http://xml.org/sax/features/xml-1.1";
    private static final String[] featureList;
    private static final Set<String> recognizedFeatures;
    private static final Set<String> supportedFeatures;
    private static final Set<String> canSetTrueFeatures;
    private static final Set<String> canSetFalseFeatures;
    private static final Map<String, Boolean> featureDefaults;

    public SAXParser() {
        this.parser.charChunks = charChunksProperty;
        HandlerBase handlerBase = new HandlerBase();
        this.parser.entResolver = handlerBase;
        this.parser.dtdHandler = handlerBase;
        this.parser.err = new XMLError();
        XMLContentHandler xMLContentHandler = new XMLContentHandler();
        try {
            this.setProperty(LEXICAL_HANDLER_PROPERTY, xMLContentHandler);
            this.setProperty(DECL_HANDLER_PROPERTY, xMLContentHandler);
            this.setContentHandler(xMLContentHandler);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    @Override
    public void setDocumentHandler(DocumentHandler documentHandler) {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(documentHandler);
        xMLContentHandler.xmlParser = this;
        try {
            this.setProperty(LEXICAL_HANDLER_PROPERTY, xMLContentHandler);
            this.setProperty(DECL_HANDLER_PROPERTY, xMLContentHandler);
            this.setContentHandler(xMLContentHandler);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getFeature(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        string = string.intern();
        if (!this.parser.parsing && string == SAX_FEATURE_VALIDATION) {
            if (bl) {
                this.setValidationMode(2);
            } else {
                this.setValidationMode(0);
            }
        } else {
            this.parser.setFeature(string, bl);
        }
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(LEXICAL_HANDLER_PROPERTY)) {
            return this.parser.lexHandler;
        }
        if (string.equals(DECL_HANDLER_PROPERTY)) {
            return this.parser.declHandler;
        }
        if (string.equals(REPORT_CHARS_CHUNKS)) {
            if (this.parser.charChunks) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (string.equals("oracle.xdkjava.security.resolveEntityDefault")) {
            return this.getAttribute(string);
        }
        String string2 = this.parser.err.getMessage1(502, string);
        throw new SAXNotRecognizedException(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(LEXICAL_HANDLER_PROPERTY)) {
            if (object instanceof LexicalHandler) {
                this.parser.lexHandler = (LexicalHandler)object;
                return;
            }
            String string2 = this.parser.err.getMessage1(503, string);
            throw new SAXNotSupportedException(string2);
        }
        if (string.equals(DECL_HANDLER_PROPERTY)) {
            if (object instanceof DeclHandler) {
                this.parser.declHandler = (DeclHandler)object;
                return;
            }
            String string3 = this.parser.err.getMessage1(503, string);
            throw new SAXNotSupportedException(string3);
        }
        if (string.equals(REPORT_CHARS_CHUNKS)) {
            if (object instanceof Boolean) {
                this.parser.charChunks = (Boolean)object;
                return;
            }
            String string4 = this.parser.err.getMessage1(503, string);
            throw new SAXNotSupportedException(string4);
        }
        if (string.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage") || string.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            this.setAttribute(string, object);
            return;
        }
        if (string.equals("oracle.xdkjava.security.entityExpansionCountLimit")) {
            this.setAttribute(string, object);
            return;
        }
        if (string.equals("oracle.xdkjava.security.resolveEntityDefault")) {
            this.setAttribute(string, object);
            return;
        }
        String string5 = this.parser.err.getMessage1(502, string);
        throw new SAXNotRecognizedException(string5);
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.parser.dtdHandler = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.parser.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler, this.cntHandler);
        this.cntHandler = contentHandler;
    }

    @Override
    public void setLexHandler(LexicalHandler lexicalHandler) {
        super.setLexHandler(lexicalHandler);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.cntHandler;
    }

    public static boolean isFeatureRecognized(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return recognizedFeatures.contains(string);
    }

    public static boolean isFeatureSupported(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return supportedFeatures.contains(string);
    }

    public static boolean canSetFeature(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (bl) {
            return canSetTrueFeatures.contains(string);
        }
        return canSetFalseFeatures.contains(string);
    }

    public static boolean getFeatureDefault(String string) throws SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!featureDefaults.containsKey(string)) {
            throw new SAXNotSupportedException(string);
        }
        return featureDefaults.get(string);
    }

    static {
        String[] stringArray;
        try {
            stringArray = XMLUtil.getProperty(REPORT_CHARS_CHUNKS, "false");
        }
        catch (Exception exception) {
            stringArray = "false";
        }
        charChunksProperty = stringArray.equals("true");
        featureList = new String[]{SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES, SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES, SAX_FEATURE_IS_STANDALONE, SAX_FEATURE_LEXICAL_HANDLER_PARAMETER_ENTITITES, SAX_FEATURE_NAMESPACES, SAX_FEATURE_NAMESPACE_PREFIXES, SAX_FEATURE_RESOLVE_DTD_URIS, SAX_FEATURE_STRING_INTERNING, SAX_FEATURE_UNICODE_NORMALIZATION_CHECKING, SAX_FEATURE_USE_ATTRIBUTES2, SAX_FEATURE_USE_LOCATOR2, SAX_FEATURE_USE_ENTITY_RESOLVER2, SAX_FEATURE_VALIDATION, SAX_FEATURE_XMLNS_URIS, SAX_FEATURE_XML_1_1};
        recognizedFeatures = new HashSet<String>();
        supportedFeatures = new HashSet<String>();
        canSetTrueFeatures = new HashSet<String>();
        canSetFalseFeatures = new HashSet<String>();
        featureDefaults = new HashMap<String, Boolean>();
        for (String string : featureList) {
            SAXParser sAXParser;
            recognizedFeatures.add(string);
            try {
                sAXParser = new SAXParser();
                boolean bl = sAXParser.getFeature(string);
                supportedFeatures.add(string);
                if (bl) {
                    featureDefaults.put(string, Boolean.TRUE);
                } else {
                    featureDefaults.put(string, Boolean.FALSE);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            try {
                sAXParser = new SAXParser();
                sAXParser.setFeature(string, true);
                canSetTrueFeatures.add(string);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            try {
                sAXParser = new SAXParser();
                sAXParser.setFeature(string, false);
                canSetFalseFeatures.add(string);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
        }
    }
}

