/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import oracle.as.management.streaming.StreamingMBean;

public class MBeanInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 10000;
    private byte[] m_buffer;
    private int m_begin;
    private int m_end;
    private StreamingMBean m_stream;
    private String m_handle;
    private boolean m_closed = false;

    public MBeanInputStream(String handle, Object mBeanProxy) throws IOException {
        this(handle, mBeanProxy, 0);
    }

    public MBeanInputStream(String handle, MBeanServerConnection conn, ObjectName name, int bufSz) throws IOException {
        this(handle, MBeanServerInvocationHandler.newProxyInstance(conn, name, StreamingMBean.class, false), bufSz);
    }

    public MBeanInputStream(String handle, Object mBeanProxy, int bufSz) throws IOException {
        if (bufSz < 1) {
            bufSz = 10000;
        }
        this.m_buffer = new byte[bufSz];
        this.m_end = bufSz;
        this.m_begin = bufSz;
        if (mBeanProxy instanceof StreamingMBean) {
            this.m_stream = (StreamingMBean)mBeanProxy;
        } else if (Proxy.isProxyClass(mBeanProxy.getClass())) {
            this.m_stream = (StreamingMBean)Proxy.newProxyInstance(StreamingMBean.class.getClassLoader(), new Class[]{StreamingMBean.class}, Proxy.getInvocationHandler(mBeanProxy));
        } else {
            throw new IOException("Cannot stream the data from " + mBeanProxy + ": must be a StreamingMBean");
        }
        this.m_handle = handle;
    }

    @Override
    public int available() {
        return this.m_end - this.m_begin;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        try {
            return (Long)this.m_stream.streamingOperation(this.m_handle, -3, new Long(n));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            IOException e = new IOException("Cannot skip: " + th.getMessage());
            e.initCause(th);
            throw e;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        int i = this.read(b);
        if (i > 0) {
            return b[0] & 0xFF;
        }
        return i;
    }

    @Override
    public synchronized int read(byte[] r) throws IOException {
        return this.read(r, 0, r.length);
    }

    @Override
    public synchronized int read(byte[] r, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int copied = 0;
        int lenToCopy = this.m_end - this.m_begin;
        int n = lenToCopy = len < lenToCopy ? len : lenToCopy;
        if (lenToCopy > 0) {
            System.arraycopy(this.m_buffer, this.m_begin, r, off, lenToCopy);
            this.m_begin += lenToCopy;
            off += lenToCopy;
            len -= lenToCopy;
            copied += lenToCopy;
        }
        if (len > 0 && this.m_end == this.m_buffer.length) {
            byte[] b;
            int expectToBuffer = (this.m_buffer.length - len % this.m_buffer.length) % this.m_buffer.length;
            lenToCopy = len + expectToBuffer;
            try {
                b = (byte[])this.m_stream.streamingOperation(this.m_handle, -1, new Integer(lenToCopy));
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable th) {
                while (th.getCause() != null && th instanceof UndeclaredThrowableException) {
                    th = th.getCause();
                }
                IOException e = new IOException("Cannot read: " + th.getMessage());
                e.initCause(th);
                throw e;
            }
            if (b != null && b.length > 0) {
                if (len > b.length) {
                    len = b.length;
                }
                lenToCopy = b.length - len;
                this.m_begin = this.m_buffer.length - expectToBuffer;
                this.m_end = this.m_begin + lenToCopy;
                System.arraycopy(b, 0, r, off, len);
                copied += len;
                System.arraycopy(b, len, this.m_buffer, this.m_begin, lenToCopy);
            }
        }
        if (copied == 0) {
            copied = -1;
        }
        return copied;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.m_closed) {
                this.m_stream.streamingOperation(this.m_handle, -2, null);
                this.m_closed = true;
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            while (th.getCause() != null && th instanceof UndeclaredThrowableException) {
                th = th.getCause();
            }
            IOException e = new IOException("Cannot close the stream: " + th.getMessage());
            e.initCause(th);
            throw e;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

