/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import oracle.dms.reporter.DMSTreeletGenerator;
import oracle.dms.reporter.LeafTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletOptions;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Indentation;

class MetricTreeletNode
extends LeafTreeletNode<Metric> {
    private DMSTreeletGenerator m_treeletGenerator = null;

    MetricTreeletNode(String name, NounTreeletNode parent, Metric mappedNode, DMSTreeletGenerator treeletGenerator) {
        super(name, parent, mappedNode);
        this.m_treeletGenerator = treeletGenerator;
        parent.addLeaf(this.m_name, this);
    }

    @Override
    public String getUnit() {
        Metric metric = (Metric)this.m_mappedNode;
        return metric.getUnits();
    }

    @Override
    public Serializable getObjValue() {
        return this.m_treeletGenerator.getMetricValue(this);
    }

    @Override
    public String getDescription() {
        Metric metric = (Metric)this.m_mappedNode;
        return metric.getDescription();
    }

    @Override
    protected void printNode(TreeletOptions options, PrintWriter out) {
        String format = options.getFormat();
        if ("pdml".equals(format)) {
            this._printPdml(options, out);
        } else {
            this._printRaw(options, out);
        }
    }

    private void _printPdml(TreeletOptions options, PrintWriter out) {
        out.print("<metric name='");
        out.print(this.getName());
        String description = null;
        if (options.includeDescriptions()) {
            description = this.getDescription();
        }
        String unit = null;
        if (options.includeUnits()) {
            unit = this.getUnit();
        }
        if (description != null || unit != null || options.includeValues()) {
            out.print("'>\n");
            if (unit != null) {
                out.print('<');
                out.print("unit");
                out.print("><![CDATA[");
                out.print(DMSUtil.xmlEscape(unit));
                out.print("]]></");
                out.print("unit");
                out.print(">\n");
            }
            if (description != null) {
                out.print('<');
                out.print("description");
                out.print("><![CDATA[");
                out.print(DMSUtil.xmlEscape(description));
                out.print("]]></");
                out.print("description");
                out.print(">\n");
            }
            if (options.includeValues()) {
                Serializable metricValue = this.getObjValue();
                if (metricValue == null) {
                    out.print("<null/>\n");
                } else if (metricValue instanceof ErrorObject) {
                    out.print("<error/>\n");
                } else {
                    out.print("<value type='");
                    out.print(TreeletNode.getValueType(metricValue));
                    out.print("'><![CDATA[");
                    out.print(DMSUtil.xmlEscape(metricValue.toString()));
                    out.print("]]></value>\n");
                }
            }
            out.print("</metric>\n");
        } else {
            out.print("'/>\n");
        }
    }

    private void _printRaw(TreeletOptions options, PrintWriter out) {
        Indentation indent = options.getIndentation();
        indent.indent(out);
        out.print(this.getName());
        out.print(":\t");
        Serializable metricValue = this.getObjValue();
        if (metricValue instanceof ErrorObject) {
            out.println(DMSNLSupport.getString("NO_VALUE"));
        } else {
            out.print(metricValue);
            String unit = this.getUnit();
            if (unit != null) {
                out.print('\t');
                out.println(unit);
            } else {
                out.println();
            }
        }
    }
}

