/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.HTTPRequestTracker;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="HTTP_REQUEST_TRACKER_DESTINATION")
public class HTTPRequestTrackerDestination
implements LoadableDestination,
EventTypeEnthusiast {
    private String m_id;
    private String m_name;
    private EventType[] m_eventTypes = new EventType[]{EventType.getEventType(EventSourceType.HTTP_REQUEST, EventActionType.START), EventType.getEventType(EventSourceType.HTTP_REQUEST, EventActionType.STOP), EventType.getEventType(EventSourceType.HTTP_REQUEST, EventActionType.CONTEXT_CHANGED)};
    private String m_excludeHeaders;
    private long m_requestThresholdSeconds = 0L;
    private long m_generateIncidentMinutes = 0L;
    private long m_maxRequestsReport = 0L;
    private String m_incidentDumps;

    @Override
    public void handleEvent(Event event) {
        if (event.getSourceType() == EventSourceType.HTTP_REQUEST && (event.getActionType() == EventActionType.START || event.getActionType() == EventActionType.STOP || event.getActionType() == EventActionType.CONTEXT_CHANGED)) {
            ExecutionContext ctx = null;
            HttpServletRequest request = null;
            HTTPRequestTracker tracker = null;
            Object[] objArr = null;
            objArr = event.getSubsidiaryObjects();
            tracker = HTTPRequestTracker.getInstance();
            if (!tracker.isActive()) {
                return;
            }
            if (objArr != null && objArr.length > 0 && objArr[0] instanceof HttpServletRequest) {
                request = (HttpServletRequest)objArr[0];
            }
            if (request != null) {
                if (event.getActionType() == EventActionType.START) {
                    ctx = event.getExecutionContext();
                    tracker.addRequest(request, ctx, event.getTime());
                } else if (event.getActionType() == EventActionType.STOP) {
                    tracker.removeRequest(request, event.getTime());
                } else if (event.getActionType() == EventActionType.CONTEXT_CHANGED) {
                    ctx = event.getExecutionContext();
                    tracker.updateRequest(request, ctx);
                }
            }
        }
    }

    public void setExcludeHeaderNames(String headerNames) {
        this.m_excludeHeaders = headerNames;
    }

    public void setRequestThresholdSeconds(String threshold) {
        this.m_requestThresholdSeconds = Long.parseLong(threshold);
    }

    public void setGenerateIncidentMinutes(String minutes) {
        this.m_generateIncidentMinutes = Long.parseLong(minutes);
    }

    public void setMaxRequestsReport(String maxRequestsReport) {
        this.m_maxRequestsReport = Long.parseLong(maxRequestsReport);
    }

    public void setIncidentDumps(String incidentDumps) {
        this.m_incidentDumps = incidentDumps;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return this.m_eventTypes;
    }

    @Override
    public boolean needsContext() {
        return true;
    }

    @Override
    public void initDestination() {
        HTTPRequestTracker tracker = HTTPRequestTracker.getInstance();
        tracker.setExcludeHeaderNames(this.m_excludeHeaders);
        tracker.setRequestThresholdSeconds(this.m_requestThresholdSeconds);
        tracker.setGenerateIncidentMinutes(this.m_generateIncidentMinutes);
        tracker.setMaxRequestsReport(this.m_maxRequestsReport);
        tracker.setIncidentDumps(this.m_incidentDumps);
        HTTPRequestTracker.activateInstance();
    }

    @Override
    public void shutdownDestination() {
        HTTPRequestTracker tracker = HTTPRequestTracker.getInstance();
        if (tracker.isActive()) {
            tracker.resetTracker();
        }
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) throws ValidationException {
    }
}

