/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.proxy.HashUtil;

@DisableTrace
class MethodSignature {
    private final String name;
    private final Class<?>[] parameterTypes;
    private final Class<?> returnType;
    private Integer hashCode = null;

    MethodSignature(Method method) {
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType();
    }

    MethodSignature(String name, Class<?>[] parameterTypes, Class<?> returnType) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature that = (MethodSignature)obj;
        if (this == that) {
            return true;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.parameterTypes, that.parameterTypes)) {
            return false;
        }
        if (null != this.returnType && null != that.returnType && !this.returnType.equals(that.returnType)) {
            throw new RuntimeException("methods \"" + this.name + "\" have the same signature \"" + this.parameterTypes + "\" but different return types: \"" + this.returnType + "\" and \"" + that.returnType + "\"");
        }
        return true;
    }

    public int hashCode() {
        if (null == this.hashCode) {
            this.hashCode = new Integer(23);
            this.hashCode = HashUtil.hash((int)this.hashCode, this.name);
            this.hashCode = HashUtil.hash((int)this.hashCode, this.parameterTypes);
        }
        return this.hashCode;
    }

    String getName() {
        return this.name;
    }

    Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    Class<?> getReturnType() {
        return this.returnType;
    }
}

