/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool.kdtree;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.ucp.common.waitfreepool.kdtree.Point;
import oracle.ucp.common.waitfreepool.kdtree.Range;

public class KDTree<T> {
    private final T data;
    private final Point point;
    private final AtomicReference<KDTree<T>> left = new AtomicReference<Object>(null);
    private final AtomicReference<KDTree<T>> right = new AtomicReference<Object>(null);
    private int depth = 0;
    private final int len;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public KDTree(T data, Point point) {
        this.data = data;
        this.point = point;
        this.len = point.size();
    }

    public KDTree(KDTree<T> tree) {
        this.data = tree.data;
        this.point = new Point(tree.point);
        this.len = this.point.size();
    }

    public void merge(KDTree<T> tree) {
        this.merge(tree, 0);
    }

    private void merge(KDTree<T> tree, int depth) {
        if (null != tree) {
            if (!this.point.sameSpace(tree.point)) {
                throw new IllegalArgumentException("incompatible space metrics");
            }
            this.merge(tree.left.getAndSet(null), depth);
            this.merge(tree.right.getAndSet(null), depth);
            tree.depth = depth + 1;
            if (this.point.get(depth % this.len).compareTo(tree.point.get(depth % this.len)) >= 0) {
                if (!this.point.equals(tree.point) && !this.right.compareAndSet(null, tree)) {
                    this.right.get().merge(tree, depth + 1);
                }
            } else if (!this.left.compareAndSet(null, tree)) {
                this.left.get().merge(tree, depth + 1);
            }
        }
    }

    public List<KDTree<T>> search(Range[] range) {
        ArrayList<KDTree<T>> storage = new ArrayList<KDTree<T>>();
        this.search(storage, range, 0, false);
        return storage;
    }

    public List<KDTree<T>> searchCopy(Range[] range) {
        ArrayList<KDTree<T>> storage = new ArrayList<KDTree<T>>();
        this.search(storage, range, 0, true);
        return storage;
    }

    private void search(List<KDTree<T>> storage, Range[] range, int depth, boolean copy) {
        if (!this.point.sameSpace(range)) {
            throw new IllegalArgumentException("incompatible vectors");
        }
        if (this.point.within(range)) {
            storage.add(copy ? new KDTree<T>(this) : this);
        }
        Range r = range[depth % this.len];
        Comparable p = this.point.get(depth % this.len);
        if ((r.infinite() || p.compareTo(r.high()) <= 0) && null != this.left.get()) {
            this.left.get().search(storage, range, depth + 1, copy);
        }
        if ((r.infinite() || p.compareTo(r.low()) >= 0) && null != this.right.get()) {
            this.right.get().search(storage, range, depth + 1, copy);
        }
    }

    KDTree<T>[] split(Range[] range) {
        KDTree[] tree = new KDTree[2];
        this.split(tree, range);
        return tree;
    }

    private void split(KDTree<T>[] tree, Range[] range) {
        int index;
        KDTree<T> copied = new KDTree<T>(this);
        int n = index = this.point.within(range) ? 0 : 1;
        if (null == tree[index]) {
            tree[index] = copied;
        } else {
            tree[index].merge(copied);
        }
        if (null != this.left.get()) {
            this.left.get().split(tree, range);
        }
        if (null != this.right.get()) {
            this.right.get().split(tree, range);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int indent) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.data).append(' ').append(this.depth).append(' ').append(this.point).append(" {\n");
        for (i = 0; i < indent + 2; ++i) {
            sb.append(' ');
        }
        sb.append(null != this.left.get() ? this.left.get().toString(indent + 2) : "null").append(",\n");
        for (i = 0; i < indent + 2; ++i) {
            sb.append(' ');
        }
        sb.append(null != this.right.get() ? this.right.get().toString(indent + 2) : "null").append("}");
        return sb.toString();
    }

    public T getData() {
        return this.data;
    }

    static {
        try {
            $$$methodRef$$$11 = KDTree.class.getDeclaredConstructor(KDTree.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = KDTree.class.getDeclaredConstructor(Object.class, Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = KDTree.class.getDeclaredMethod("getData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = KDTree.class.getDeclaredMethod("toString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = KDTree.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = KDTree.class.getDeclaredMethod("split", KDTree[].class, Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = KDTree.class.getDeclaredMethod("split", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = KDTree.class.getDeclaredMethod("search", List.class, Range[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = KDTree.class.getDeclaredMethod("searchCopy", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = KDTree.class.getDeclaredMethod("search", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = KDTree.class.getDeclaredMethod("merge", KDTree.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = KDTree.class.getDeclaredMethod("merge", KDTree.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

