/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.ucp.logging.annotations.DisableTrace;

@DisableTrace
public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    private final Object[] ring;
    private int pointer = 0;
    private int nUpdates = 0;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int capacity) {
        this.ring = new Object[capacity];
    }

    private int next(int i) {
        return (i + 1) % this.getCapacity();
    }

    private int previous(int i) {
        int j = i - 1;
        return j < 0 ? this.getCapacity() - 1 : j;
    }

    public final void addItem(T item) {
        this.wLock.lock();
        try {
            this.pointer = this.next(this.pointer);
            this.ring[this.pointer] = item;
            if (++this.nUpdates < 0) {
                this.nUpdates = Integer.MAX_VALUE;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    public final int getCapacity() {
        return this.ring.length;
    }

    public final int getNumberOfUpdates() {
        this.rLock.lock();
        try {
            int n = this.nUpdates;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> getAsList() {
        this.rLock.lock();
        try {
            ArrayList<Object> listHistory = new ArrayList<Object>();
            int index = this.pointer;
            for (int i = 0; i < Math.min(this.getCapacity(), this.getNumberOfUpdates()); ++i) {
                listHistory.add(this.ring[index]);
                index = this.previous(index);
            }
            ArrayList<Object> arrayList = listHistory;
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @DisableTrace
    public String toString() {
        this.rLock.lock();
        try {
            String string = this.toString(Math.min(this.getCapacity(), this.getNumberOfUpdates()));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisableTrace
    public String toString(int nItems) {
        StringBuilder sb = new StringBuilder();
        this.rLock.lock();
        try {
            int i = this.pointer;
            int n = nItems;
            if (n < 1) {
                String string = "";
                return string;
            }
            do {
                Object item;
                if (null == (item = this.ring[i])) continue;
                sb.append(item.toString());
            } while ((i = this.previous(i)) != this.pointer && --n > 0);
        }
        finally {
            this.rLock.unlock();
        }
        return sb.toString();
    }

    public final void clear() {
        this.wLock.lock();
        try {
            this.pointer = 0;
            this.nUpdates = 0;
        }
        finally {
            this.wLock.unlock();
        }
    }

    static {
        try {
            $$$methodRef$$$10 = RingBuffer.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = RingBuffer.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = RingBuffer.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = RingBuffer.class.getDeclaredMethod("toString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = RingBuffer.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = RingBuffer.class.getDeclaredMethod("getAsList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = RingBuffer.class.getDeclaredMethod("getNumberOfUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = RingBuffer.class.getDeclaredMethod("getCapacity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = RingBuffer.class.getDeclaredMethod("addItem", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = RingBuffer.class.getDeclaredMethod("previous", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = RingBuffer.class.getDeclaredMethod("next", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

