/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleReplayableConnectionConnectionPool
extends OracleConnectionConnectionPool
implements oracle.jdbc.replay.internal.ConnectionInitializationCallback {
    static final String ORDS_REST_LABEL = "oracle.dbtools.jdbc.label.schema";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public OracleReplayableConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
        this.core.connectionSource().setReplayable(true);
    }

    @Override
    public void start(boolean keepMetadataConn) throws UniversalConnectionPoolException {
        if (!this.useVanillaObjects) {
            ReplayDataSourceConnectionFactoryAdapter rcfa = (ReplayDataSourceConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
            OracleDataSource rds = (OracleDataSource)rcfa.getDataSource();
            try {
                rds.registerConnectionInitializationCallback((oracle.jdbc.replay.internal.ConnectionInitializationCallback)this);
            }
            catch (SQLException sqlexc) {
                ClioSupport.ilogThrowing(null, null, null, null, sqlexc);
            }
        }
        super.start(keepMetadataConn);
    }

    public void initialize(Connection connection) throws SQLException {
        try {
            if (connection == null) {
                throw UCPErrorHandler.newSQLException(65);
            }
            Object ucpConnProxy = ((ReplayableConnection)connection).getProxyObject();
            if (ucpConnProxy == null || !(ucpConnProxy instanceof Poolable)) {
                throw UCPErrorHandler.newSQLException(66);
            }
            OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)((Poolable)ucpConnProxy).getPooledObject();
            oupc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
            ClioSupport.ilogFinest(null, null, null, null, "AC initialize(): found UPC for " + connection + ", status: RECONNECTING");
            if (this.isFailoverEnabled()) {
                CoreConnection coreConn = oupc.getDelegator();
                coreConn.reinitialize();
                if (this.m_racManager != null) {
                    this.m_racManager.connectionClosed(oupc);
                }
                oupc.initFailoverParameters();
                oupc.updateInstanceNumber();
                if (this.m_racManager != null) {
                    this.m_racManager.connectionOpened(oupc);
                }
            }
            oupc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
            ClioSupport.ilogFinest(null, null, null, null, "AC initialize(): metadata update done for " + connection + ", status: NORMAL");
            oracle.ucp.ConnectionLabelingCallback labelingCbk = this.getConnectionLabelingCallback();
            if (labelingCbk != null) {
                boolean successfullyConfigured;
                ClioSupport.ilogFinest(null, null, null, null, "Registered labeling callback: " + labelingCbk);
                Properties reqLabels = labelingCbk instanceof ConnectionLabelingCallback ? ((ConnectionLabelingCallback)labelingCbk).getRequestedLabels() : oupc.getConnectionLabels();
                ClioSupport.ilogFinest(null, null, null, null, "Requested labels: " + reqLabels);
                if (null != reqLabels && reqLabels.getProperty(ORDS_REST_LABEL) != null) {
                    ConnectionRetrievalInfo criNoLabels = oupc.getConnectionRetrievalInfo().getCopyWithNoLabels();
                    oupc.setConnectionRetrievalInfo(criNoLabels);
                    ClioSupport.ilogFinest(null, null, null, null, "Cleared labels on new connection");
                }
                if (!(successfullyConfigured = labelingCbk.configure(reqLabels, this.getConnectionObjectForLabelingConfigure(oupc)))) {
                    ClioSupport.ilogWarning(null, null, null, null, "failed to configure connection");
                    throw new SQLException("failed to configure connection");
                }
                ClioSupport.ilogFinest(null, null, null, null, "After configure, new labels: " + oupc.getConnectionLabels());
            } else {
                ConnectionInitializationCallback connInitCallback = this.getConnectionInitializationCallback();
                if (connInitCallback != null) {
                    connInitCallback.initialize(connection);
                }
            }
            this.incrementConnectionsCreatedCount();
            this.incrementCumulativeConnectionsCreated();
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            throw e;
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            SQLException newSqlExc = UCPErrorHandler.newSQLException(68, e);
            throw newSqlExc;
        }
        catch (Error | RuntimeException e) {
            ClioSupport.ilogWarning(null, null, null, null, "got unchecked exception in AC reinitialization callback");
            ClioSupport.ilogThrowing(null, null, null, null, e);
            throw e;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = OracleReplayableConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleReplayableConnectionConnectionPool.class.getDeclaredMethod("initialize", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleReplayableConnectionConnectionPool.class.getDeclaredMethod("start", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

