/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.other.ConnectionProxy;
import oracle.ucp.jdbc.proxy.other.ResultSetProxy;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected Chain<ResultSetProxy> resultSetsToClose = new MapChain<ResultSetProxy>();
    private Chain.Atom<StatementProxy> statementChainAtom = null;
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private boolean sqlWithQueryTimeoutInProgress = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        ConnectionProxy c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = (ConnectionProxy)this.getCreator())) {
            upc = this.proxiedPooledConnection = c.getUPC();
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        ConnectionProxy c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = (ConnectionProxy)this.getCreator())) {
            ucp = this.proxiedPool = c.getUCP();
        }
        return ucp;
    }

    @Override
    public boolean isLogicallyClosed() {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.sqlWithQueryTimeoutInProgress = seconds > 0;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().setQueryTimeout(seconds);
        this.getUPC().heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().closeOnCompletion();
        this.getUPC().heartbeat();
    }

    public boolean isClosed() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxy)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.closed.get()) {
            return;
        }
        for (ResultSetProxy rs : this.resultSetsToClose.toList()) {
            rs.close();
        }
        this.resultSetsToClose.clear();
        this.statementChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
        upc.heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        upc.setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        ConnectionProxy connProxy = (ConnectionProxy)this.getCreator();
        if (connProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class}), @Signature(name="getResultSet", args={}), @Signature(name="getGeneratedKeys", args={})})
    protected ResultSet post(Method m, ResultSet result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.sqlWithQueryTimeoutInProgress = false;
        upc.setSqlWithQueryTimeoutInProgress(false);
        this.saveResultSetProxy(result);
        return result;
    }

    @Post
    protected Object postRest(Method m, Object result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveResultSetProxy(result);
        return result;
    }

    protected void saveResultSetProxy(Object result) {
        if (result instanceof ResultSetProxy) {
            ResultSetProxy resultSetProxy = (ResultSetProxy)result;
            resultSetProxy.setResultSetChainAtom(this.resultSetsToClose.add(resultSetProxy));
        }
    }

    @Post
    protected void postRestVoid(Method m) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorVoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((ConnectionProxy)this.getCreator()).handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorVoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        this.getUPC().heartbeat();
        ((ConnectionProxy)this.getCreator()).handleRuntimeException(e);
        throw e;
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof StatementProxy ? ((StatementProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    static {
        try {
            $$$methodRef$$$21 = StatementProxy.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = StatementProxy.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = StatementProxy.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = StatementProxy.class.getDeclaredMethod("onRuntimeExceptionError", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = StatementProxy.class.getDeclaredMethod("onRuntimeExceptionErrorVoid", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = StatementProxy.class.getDeclaredMethod("onSQLExceptionError", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = StatementProxy.class.getDeclaredMethod("onSQLExceptionErrorVoid", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = StatementProxy.class.getDeclaredMethod("postRestVoid", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = StatementProxy.class.getDeclaredMethod("saveResultSetProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = StatementProxy.class.getDeclaredMethod("postRest", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = StatementProxy.class.getDeclaredMethod("post", Method.class, ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = StatementProxy.class.getDeclaredMethod("pre", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = StatementProxy.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = StatementProxy.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = StatementProxy.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = StatementProxy.class.getDeclaredMethod("closeOnCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = StatementProxy.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = StatementProxy.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = StatementProxy.class.getDeclaredMethod("isLogicallyClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = StatementProxy.class.getDeclaredMethod("getUCP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = StatementProxy.class.getDeclaredMethod("getUPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = StatementProxy.class.getDeclaredMethod("setStatementChainAtom", Chain.Atom.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

