/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Logger;
import javax.sql.XAConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool;
import oracle.ucp.jdbc.proxy.XAConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleXAConnectionConnectionPool
extends OraclePooledConnectionConnectionPool {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleXAConnectionConnectionPool.class.getCanonicalName());

    public OracleXAConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    public XAConnection getXAConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return (XAConnection)super.getPooledConnection(connectionRetrievalInfo);
    }

    public boolean returnXAConnection(XAConnection xaConnection) throws UniversalConnectionPoolException {
        return super.returnPooledConnection(xaConnection);
    }

    public boolean closeXAConnection(XAConnection xaConnection) throws UniversalConnectionPoolException {
        return super.closePooledConnection(xaConnection);
    }

    protected void validateConstructor(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (!(connectionFactoryAdapter instanceof XADataSourceConnectionFactoryAdapter)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(106);
            logger.throwing(this.getClass().getName(), "validateConstructor", ucpe);
            throw ucpe;
        }
    }

    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        JDBCUniversalPooledConnection jupc = (JDBCUniversalPooledConnection)upc;
        try {
            return XAConnectionProxyFactory.createConnectionProxy(this, jupc);
        }
        catch (UniversalConnectionPoolException exc) {
            return null;
        }
    }
}

