/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.XAConnectionConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleXAConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.XAConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class PoolXADataSourceImpl
extends PoolDataSourceImpl
implements PoolXADataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(PoolXADataSourceImpl.class.getCanonicalName());
    private XADataSource m_xaDataSource = null;

    protected void createPoolWithDefaultProperties() throws SQLException {
        String className = this.getClass().getName();
        int errCode = 27;
        try {
            this.m_xaDataSource = (XADataSource)this.m_connectionFactory;
            logger.finest("XADataSource is set");
            errCode = 1;
            if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc")) {
                OracleXADataSourceConnectionFactoryAdapter ocfa = new OracleXADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new OracleXAConnectionConnectionPool(ocfa);
                ocfa.setUniversalConnectionPool(this.m_cp);
            } else {
                XADataSourceConnectionFactoryAdapter cfa = new XADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new XAConnectionConnectionPool(cfa);
                cfa.setUniversalConnectionPool(this.m_cp);
            }
            logger.fine("connection pool is created");
        }
        catch (Exception e) {
            logger.throwing(className, "cannot build pool", e);
            UCPErrorHandler.throwSQLException(errCode, e);
        }
    }

    public Connection getConnection() throws SQLException {
        logger.finest("PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        logger.finest("PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    public Connection getConnection(Properties labels) throws SQLException {
        logger.finest("PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    public Connection getConnection(String username, String password, Properties labels) throws SQLException {
        logger.finest("PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), null);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return this.getXAConnection(user, password, null);
    }

    public XAConnection getXAConnection(Properties labels) throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), labels);
    }

    public XAConnection getXAConnection(String username, String password, Properties labels) throws SQLException {
        this.startPool();
        XAConnection xaconn = null;
        try {
            JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(username, password, labels);
            JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)this.m_cp.borrowConnection(cri);
            jdbcPooledConnection.setMaxStatements(this.m_cp.getMaxStatements());
            xaconn = (XAConnection)XAConnectionProxyFactory.createConnectionProxy(this.m_cp, jdbcPooledConnection);
        }
        catch (NoAvailableConnectionsException e) {
            UCPErrorHandler.throwSQLException(28, e);
        }
        catch (UniversalConnectionPoolException e) {
            UCPErrorHandler.throwSQLException(29, e);
        }
        return xaconn;
    }
}

