/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class DriverConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(DriverConnectionFactoryAdapter.class.getCanonicalName());
    protected Driver m_driver;
    protected Properties m_connectionProperties;

    public DriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionProperties) throws UniversalConnectionPoolException {
        if (null == driver) {
            UCPErrorHandler.throwUniversalConnectionPoolException(268);
        }
        if (url == null || "".equals(url)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(269);
        }
        this.m_driver = driver;
        this.m_url = url;
        this.m_connectionProperties = connectionProperties;
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        Connection connection = null;
        try {
            Properties connProps = (Properties)this.m_connectionProperties.clone();
            connection = this.m_driver.connect(this.m_url, connProps);
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(257, sqlException);
        }
        logger.finest("connection is created successfully");
        return connection;
    }

    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
        logger.finest("connection is closed successfully");
    }
}

