/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class ConnectionPoolDataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(ConnectionPoolDataSourceConnectionFactoryAdapter.class.getCanonicalName());
    protected ConnectionPoolDataSource m_connectionPoolDataSource;

    public ConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource) throws UniversalConnectionPoolException {
        if (null == connectionPoolDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(251);
        }
        this.m_connectionPoolDataSource = connectionPoolDataSource;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.m_connectionPoolDataSource;
    }

    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        PooledConnection pooledConnection = null;
        try {
            pooledConnection = this.m_connectionPoolDataSource.getPooledConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword());
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                pooledConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(253, sqlException);
        }
        logger.fine("pooled connection created successfully");
        return pooledConnection;
    }

    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof PooledConnection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(254);
        }
        PooledConnection pooledConnection = (PooledConnection)connection;
        UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
        if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
            pooledConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
        logger.fine("pooled connection is closed successfully");
    }
}

