/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.common.UniversalConnectionPoolBase;

public class UniversalConnectionPoolStatisticsImpl
implements UniversalConnectionPoolStatistics {
    private final UniversalConnectionPoolBase m_cp;

    protected UniversalConnectionPoolStatisticsImpl(UniversalConnectionPoolBase cp) {
        assert (cp != null);
        this.m_cp = cp;
    }

    public int getTotalConnectionsCount() {
        return this.m_cp.getTotalConnectionsCount();
    }

    public int getAvailableConnectionsCount() {
        return this.m_cp.getAvailableConnectionsCount();
    }

    public int getBorrowedConnectionsCount() {
        return this.m_cp.getBorrowedConnectionsCount();
    }

    public int getAverageBorrowedConnectionsCount() {
        return this.m_cp.getAverageBorrowedConnectionsCount();
    }

    public int getPeakConnectionsCount() {
        return this.m_cp.getPeakConnectionsCount();
    }

    public int getRemainingPoolCapacityCount() {
        int count = this.m_cp.getMaxPoolSize() - this.m_cp.getTotalConnectionsCount();
        return count > 0 ? count : 0;
    }

    public int getLabeledConnectionsCount() {
        return this.m_cp.getLabeledConnectionsCount();
    }

    public int getConnectionsCreatedCount() {
        return this.m_cp.getConnectionsCreatedCount();
    }

    public int getConnectionsClosedCount() {
        return this.m_cp.getConnectionsClosedCount();
    }

    public long getAverageConnectionWaitTime() {
        long averageConnectionWaitTime = 0L;
        long totalCount = this.m_cp.getCumulativeSuccessfulConnectionWaitCount() + this.m_cp.getCumulativeFailedConnectionWaitCount();
        if (totalCount > 0L) {
            long totalTime = this.m_cp.getCumulativeSuccessfulConnectionWaitTime() + this.m_cp.getCumulativeFailedConnectionWaitTime();
            averageConnectionWaitTime = Math.round(totalTime / totalCount);
        }
        return averageConnectionWaitTime;
    }

    public long getPeakConnectionWaitTime() {
        return this.m_cp.getPeakConnectionWaitTime();
    }

    public int getAbandonedConnectionsCount() {
        return this.m_cp.getAbandonedConnectionsCount();
    }

    public int getPendingRequestsCount() {
        return this.m_cp.getPendingRequestsCount();
    }

    public long getCumulativeConnectionWaitTime() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitTime() + this.m_cp.getCumulativeFailedConnectionWaitTime();
    }

    public long getCumulativeConnectionBorrowedCount() {
        return this.m_cp.getCumulativeConnectionBorrowedCount();
    }

    public long getCumulativeConnectionUseTime() {
        return this.m_cp.getCumulativeConnectionUseTime();
    }

    public long getCumulativeConnectionReturnedCount() {
        return this.m_cp.getCumulativeConnectionReturnedCount();
    }

    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitTime();
    }

    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitCount();
    }

    public long getCumulativeFailedConnectionWaitTime() {
        return this.m_cp.getCumulativeFailedConnectionWaitTime();
    }

    public long getCumulativeFailedConnectionWaitCount() {
        return this.m_cp.getCumulativeFailedConnectionWaitCount();
    }

    public String toString() {
        return "Statistics: " + "(AvailableConnectionsCount=" + this.getAvailableConnectionsCount() + "), " + "(BorrowedConnectionsCount=" + this.getBorrowedConnectionsCount() + "), " + "(TotalConnectionsCount=" + this.getTotalConnectionsCount() + "), " + "(ConnectionsCreatedCount=" + this.getConnectionsCreatedCount() + "), " + "(ConnectionsClosedCount=" + this.getConnectionsClosedCount() + "), " + "(AbandonedConnectionsCount=" + this.getAbandonedConnectionsCount() + "), " + "(LabeledConnectionsCount=" + this.getLabeledConnectionsCount() + "), " + "(PendingRequestsCount=" + this.getPendingRequestsCount() + "), " + "(RemainingPoolCapacityCount=" + this.getRemainingPoolCapacityCount() + "), " + "(PeakConnectionsCount=" + this.getPeakConnectionsCount() + "), " + "(PeakConnectionWaitTime=" + this.getPeakConnectionWaitTime() + "), " + "(AverageBorrowedConnectionsCount=" + this.getAverageBorrowedConnectionsCount() + "), " + "(AverageConnectionWaitTime=" + this.getAverageConnectionWaitTime() + "), " + "(CumulativeConnectionBorrowedCount=" + this.getCumulativeConnectionBorrowedCount() + "), " + "(CumulativeConnectionReturnedCount=" + this.getCumulativeConnectionReturnedCount() + "), " + "(CumulativeConnectionUseTime=" + this.getCumulativeConnectionUseTime() + "), " + "(CumulativeConnectionWaitTime=" + this.getCumulativeConnectionWaitTime() + "), " + "(CumulativeSuccessfulConnectionWaitCount=" + this.getCumulativeSuccessfulConnectionWaitCount() + ")," + "(CumulativeSuccessfulConnectionWaitTime=" + this.getCumulativeSuccessfulConnectionWaitTime() + "), " + "(CumulativeFailedConnectionWaitCount=" + this.getCumulativeFailedConnectionWaitCount() + "), " + "(CumulativeFailedConnectionWaitTime=" + this.getCumulativeFailedConnectionWaitTime() + ')';
    }
}

