/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.common;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import oracle.net.url.common.NodeType;
import oracle.net.url.common.ParameterNode;

public interface Node {
    public String name();

    public void name(String var1);

    public NodeType type();

    public Node param(String var1, String var2);

    public <T extends Node> Node addChild(Class<T> var1, Consumer<T> var2);

    public List<Node> childNodes();

    public List<Node> childNodes(NodeType var1);

    public List<ParameterNode> getParams();

    public Node parent();

    default public String nodeTreeAsString() {
        StringBuilder sb = new StringBuilder();
        Node.nodeTreeAsString(this, "  ", sb);
        return sb.toString();
    }

    public static void nodeTreeAsString(Node node, String indent, StringBuilder builder) {
        builder.append("\n").append(indent).append(node.name());
        if (node.getParams() != null && !node.getParams().isEmpty()) {
            builder.append(" ").append(node.getParams());
        }
        if (node.childNodes() == null || node.childNodes().isEmpty()) {
            return;
        }
        node.childNodes().forEach(child -> Node.nodeTreeAsString(child, indent + "  ", builder));
    }

    default public String getParamValue(String name) {
        ParameterNode pn = this.getParams().stream().filter(p -> p.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        return pn == null ? null : pn.value();
    }

    default public List<String> getAllParamValues(String name) {
        return this.getParams().stream().filter(p -> p.name().equalsIgnoreCase(name)).map(ParameterNode::value).collect(Collectors.toList());
    }

    default public String findFirst(String name) {
        String paramValue = this.getParamValue(name);
        if (paramValue != null) {
            return paramValue;
        }
        for (Node child : this.childNodes()) {
            paramValue = child.findFirst(name);
            if (paramValue == null) continue;
            return paramValue;
        }
        return null;
    }

    default public List<String> findAll(String name) {
        List<String> paramValues = this.getAllParamValues(name);
        for (Node child : this.childNodes()) {
            paramValues.addAll(child.findAll(name));
        }
        return paramValues;
    }

    default public <T extends Node> List<T> childNodes(Class<T> nt) {
        return this.childNodes().stream().filter(n -> nt.isAssignableFrom(n.getClass())).map(n -> n).collect(Collectors.toList());
    }
}

