/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIORedirectPacket
extends NIOPacket {
    String redirectData;

    NIORedirectPacket(NIOHeader header, SessionAtts session) throws IOException {
        super(header, session);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        short rdlen = this.session.payloadBufferForRead.getShort();
        if (rdlen > 0) {
            byte[] data = null;
            if (this.session.payloadBufferForRead.hasRemaining()) {
                data = new byte[rdlen];
                this.session.payloadBufferForRead.get(data);
            } else {
                data = this.session.dataChannel.readPayloadDataFromSocketChannel(rdlen);
            }
            this.redirectData = new String(data, Charset.forName("US-ASCII"));
        }
    }
}

