/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class BequeathModeMediator {
    private static final String CLASS_NAME = BequeathModeMediator.class.getName();
    private final InputStream in;
    private final OutputStream out;
    private Lock statusChangeLock = new ReentrantLock();
    private MediationStatus status = new MediationStatus(MediationStatus.State.NOT_STARTED, null);
    private static final byte[] NTP0 = new byte[]{78, 84, 80, 48};

    public MediationStatus getStatus() {
        try {
            this.statusChangeLock.lock();
            MediationStatus mediationStatus = this.status;
            return mediationStatus;
        }
        finally {
            this.statusChangeLock.unlock();
        }
    }

    private void setStatus(MediationStatus.State state, Object details) {
        try {
            this.statusChangeLock.lock();
            this.status = new MediationStatus(state, details);
        }
        finally {
            this.statusChangeLock.unlock();
        }
    }

    public BequeathModeMediator(InputStream in, OutputStream out) {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null");
        }
        this.in = in;
        this.out = out;
    }

    private void mediate() throws IllegalStateException, IOException {
        int nextByteRead;
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "mediate", "waiting for NTP0 handshake", null, null);
        int limit = 32;
        ByteArrayOutputStream ntpOs = new ByteArrayOutputStream(limit);
        for (byte b : NTP0) {
            nextByteRead = this.in.read();
            if (nextByteRead == -1) {
                throw new IOException("input closed while mediation");
            }
            ntpOs.write(nextByteRead);
            if (nextByteRead == b) continue;
            throw new IllegalStateException(String.format("NTP0 prefix not properly received expected [%s] got [%s]", Arrays.toString(NTP0), ntpOs));
        }
        nextByteRead = this.in.read();
        ntpOs.write(nextByteRead);
        if (nextByteRead != 32) {
            throw new IllegalStateException(String.format("NTP0 prefix not properly received expected space got [%s]", nextByteRead));
        }
        nextByteRead = -1;
        boolean gotOneNumber = false;
        while (this.in.available() > 0 && nextByteRead != 10) {
            nextByteRead = this.in.read();
            ntpOs.write(nextByteRead);
            if ((nextByteRead < 48 || nextByteRead > 57) && nextByteRead != 10) {
                throw new IllegalStateException(String.format("Bequeath server ID  not properly received expected number got [%s]", ntpOs));
            }
            gotOneNumber = true;
            if (--limit != 0) continue;
            throw new IllegalStateException("too manny byte read");
        }
        if (!gotOneNumber) {
            throw new IllegalStateException(String.format("Bequeath handshake not properly received got [%s]", ntpOs));
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "mediate", "handshake done, got [{0}]", (String)null, (Throwable)null, (Object)ntpOs);
        this.out.flush();
    }

    public void startMediation() {
        try {
            this.setStatus(MediationStatus.State.STARTED, null);
            this.mediate();
            this.setStatus(MediationStatus.State.FINISHED, null);
        }
        catch (Exception e) {
            this.setStatus(MediationStatus.State.FAILED, e);
        }
    }

    public static class MediationStatus {
        private final State state;
        private final Object details;

        public MediationStatus(State state, Object details) {
            if (state == null) {
                throw new IllegalArgumentException("state cannot be null");
            }
            this.state = state;
            this.details = details;
        }

        public State getState() {
            return this.state;
        }

        public Object getDetails() {
            return this.details;
        }

        public static enum State {
            NOT_STARTED,
            STARTED,
            FINISHED,
            FAILED;

        }
    }
}

