/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.AbstractTrueCacheCallableStatement;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.AbstractTrueCachePreparedStatement;
import oracle.jdbc.driver.AbstractTrueCacheResultSet;
import oracle.jdbc.driver.AbstractTrueCacheStatement;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.proxy.ProxyFactory;

class TrueCacheDriverExtension
extends OracleDriverExtension {
    static ProxyFactory PROXY_FACTORY = null;
    private static final Monitor proxyFactoryLock = Monitor.newInstance();

    TrueCacheDriverExtension() {
    }

    @Override
    Connection getConnection(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        Connection connection = null;
        connection = (Connection)PROXY_FACTORY.proxyForType(OracleConnection.class);
        ((AbstractTrueCacheConnection)((Object)connection)).initialize(url, info, this, builder);
        return connection;
    }

    final CompletionStage<Connection> getConnectionAsync(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the True Cache driver"));
    }

    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection conn, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        oracle.jdbc.internal.OracleStatement stmt = null;
        stmt = (oracle.jdbc.internal.OracleStatement)PROXY_FACTORY.proxyForType(oracle.jdbc.internal.OracleStatement.class, conn);
        ((AbstractTrueCacheStatement)((Object)stmt)).initialize((AbstractTrueCacheConnection)((Object)conn), resultSetType, 0);
        return stmt;
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection conn, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        OraclePreparedStatement pstmt = null;
        pstmt = (OraclePreparedStatement)PROXY_FACTORY.proxyForType(OraclePreparedStatement.class, conn);
        ((AbstractTrueCachePreparedStatement)((Object)pstmt)).initialize((AbstractTrueCacheConnection)((Object)conn), sql, resultSetType, 1);
        return pstmt;
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection conn, String sql, AutoKeyInfo autoKeyInfo) throws SQLException {
        OraclePreparedStatement pstmt = null;
        pstmt = (OraclePreparedStatement)PROXY_FACTORY.proxyForType(OraclePreparedStatement.class, conn);
        ((AbstractTrueCachePreparedStatement)((Object)pstmt)).initialize((AbstractTrueCacheConnection)((Object)conn), sql, autoKeyInfo, 1);
        return pstmt;
    }

    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection conn, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        OracleCallableStatement cstmt = null;
        cstmt = (OracleCallableStatement)PROXY_FACTORY.proxyForType(OracleCallableStatement.class, conn);
        ((AbstractTrueCacheCallableStatement)((Object)cstmt)).initialize((AbstractTrueCacheConnection)((Object)conn), sql, resultSetType, 2);
        return cstmt;
    }

    @Override
    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        return new T4CInputStream(stmt, index, accessor);
    }

    static {
        try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
            if (PROXY_FACTORY == null) {
                PROXY_FACTORY = ProxyFactory.createProxyFactory(AbstractTrueCacheConnection.class, AbstractTrueCacheStatement.class, AbstractTrueCachePreparedStatement.class, AbstractTrueCacheCallableStatement.class, AbstractTrueCacheResultSet.class);
            }
        }
    }
}

