/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.sql.BLOB;
import oracle.sql.Datum;

final class T4C8TTIBlob
extends T4C8TTILob {
    private static final String CLASS_NAME = T4C8TTIBlob.class.getName();

    T4C8TTIBlob(T4CConnection _conn) {
        super(_conn);
    }

    @Override
    Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "createTemporaryLob", "cache={0}, duration={1}", (String)null, (Throwable)null, (Object)cache, (Object)duration);
        if (duration == 12) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158).fillInStackTrace();
        }
        BLOB blob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        int tempLobSize = this.getTemporaryLobSize();
        this.sourceLobLocator = new byte[tempLobSize];
        this.sourceLobLocator[1] = (byte)(tempLobSize - 2);
        this.characterSet = 1;
        this.destinationOffset = 113L;
        this.destinationLength = duration;
        this.lobamt = duration;
        this.sendLobamt = true;
        this.nullO2U = true;
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = cache ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            blob = new BLOB((OracleConnection)conn, this.sourceLobLocator);
        }
        return blob;
    }

    @Override
    boolean openLob(byte[] lobLocator, int mode) throws SQLException, IOException {
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this.openLob(lobLocator, kokl_mode, 32768);
        return wasOpened;
    }

    @Override
    boolean closeLob(byte[] lobLocator) throws SQLException, IOException {
        boolean wasClosed = false;
        wasClosed = this.closeLob(lobLocator, 65536);
        return wasClosed;
    }

    @Override
    boolean isOpenLob(byte[] lobLocator) throws SQLException, IOException {
        return this.isOpenLob(lobLocator, 69632);
    }
}

