/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleClosedStatement;
import oracle.jdbc.driver.OracleExecutingStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Wrappable;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;

class OracleStatementWrapper
implements oracle.jdbc.internal.OracleStatement {
    private int forEquals;
    protected oracle.jdbc.internal.OracleStatement statement;
    static final OracleCallableStatement closedStatement = new OracleClosedStatement(9);
    static final OracleCallableStatement closedStatementAC = new OracleClosedStatement(8);
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    long checkSum = 0L;
    boolean checkSumComputationFailure = false;
    Object acProxy;

    OracleStatementWrapper(oracle.jdbc.OracleStatement stmt) throws SQLException {
        this.forEquals = stmt.hashCode();
        this.statement = (oracle.jdbc.internal.OracleStatement)stmt;
        ((Wrappable)((Object)stmt)).setWrapper(this);
        this.initializeLogger();
    }

    private void initializeLogger() {
    }

    @Override
    public void close() throws SQLException {
        if (this.statement == closedStatement || this.statement == closedStatementAC) {
            return;
        }
        this.awaitAsyncExecution();
        this.endAsyncExecution();
        this.checkSum = ((OracleStatement)this.statement).checkSum = this.checkSum;
        this.checkSumComputationFailure = ((OracleStatement)this.statement).checkSumComputationFailure;
        this.sqlKind = ((OracleStatement)this.statement).sqlKind;
        this.statement.close();
        ((Wrappable)((Object)this.statement)).setWrapper(null);
        this.statement = closedStatement;
    }

    void beClosed(boolean isConnClosed) throws SQLException {
        this.close();
        this.statement = isConnClosed ? closedStatementAC : closedStatement;
    }

    @Override
    public void closeWithKey(String _key) throws SQLException {
        this.statement.closeWithKey(_key);
        this.statement = closedStatement;
    }

    void beginAsyncExecution() {
        this.statement = new OracleExecutingStatement(this.statement);
    }

    void endAsyncExecution() {
        oracle.jdbc.internal.OracleStatement statement = this.statement;
        if (!(statement instanceof OracleExecutingStatement)) {
            return;
        }
        OracleExecutingStatement executing = (OracleExecutingStatement)statement;
        executing.endExecution();
        try {
            this.statement = executing.unwrap(oracle.jdbc.internal.OracleStatement.class);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }

    boolean isExecutingAsync() {
        return this.statement instanceof OracleExecutingStatement;
    }

    void awaitAsyncExecution() {
        oracle.jdbc.internal.OracleStatement statement = this.statement;
        if (!(statement instanceof OracleExecutingStatement)) {
            return;
        }
        ((OracleExecutingStatement)statement).awaitExecution();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass() == rhs.getClass() && this.forEquals == ((OracleStatementWrapper)rhs).hashCode();
    }

    public int hashCode() {
        return this.forEquals;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    @Override
    public void setFetchDirection(int _fetchDirection) throws SQLException {
        this.statement.setFetchDirection(_fetchDirection);
    }

    @Override
    public void setFetchSize(int _fetchSize) throws SQLException {
        this.statement.setFetchSize(_fetchSize);
    }

    @Override
    public void setMaxFieldSize(int _maxFieldSize) throws SQLException {
        this.statement.setMaxFieldSize(_maxFieldSize);
    }

    @Override
    public void setMaxRows(int _maxRows) throws SQLException {
        this.statement.setMaxRows(_maxRows);
    }

    @Override
    public void setQueryTimeout(int _queryTimeout) throws SQLException {
        this.statement.setQueryTimeout(_queryTimeout);
    }

    @Override
    public boolean getMoreResults(int _moreResults) throws SQLException {
        return this.statement.getMoreResults(_moreResults);
    }

    @Override
    public void setEscapeProcessing(boolean _escapeProcessing) throws SQLException {
        this.statement.setEscapeProcessing(_escapeProcessing);
    }

    @Override
    public int executeUpdate(String _sqlString) throws SQLException {
        return this.statement.executeUpdate(_sqlString);
    }

    @Override
    public void addBatch(String _sqlString) throws SQLException {
        this.statement.addBatch(_sqlString);
    }

    @Override
    public void setCursorName(String _cursorName) throws SQLException {
        this.statement.setCursorName(_cursorName);
    }

    @Override
    public boolean execute(String _sqlString) throws SQLException {
        return this.statement.execute(_sqlString);
    }

    @Override
    public int executeUpdate(String _sqlString, int _autoGenerateKeys) throws SQLException {
        return this.statement.executeUpdate(_sqlString, _autoGenerateKeys);
    }

    @Override
    public boolean execute(String _sqlString, int _autoGenerateKeys) throws SQLException {
        return this.statement.execute(_sqlString, _autoGenerateKeys);
    }

    @Override
    public int executeUpdate(String _sqlString, int[] _columnIndices) throws SQLException {
        return this.statement.executeUpdate(_sqlString, _columnIndices);
    }

    @Override
    public boolean execute(String _sqlString, int[] _columnIndices) throws SQLException {
        return this.statement.execute(_sqlString, _columnIndices);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public int executeUpdate(String _sqlString, String[] _columnNames) throws SQLException {
        return this.statement.executeUpdate(_sqlString, _columnNames);
    }

    @Override
    public boolean execute(String _sqlString, String[] _columnNames) throws SQLException {
        return this.statement.execute(_sqlString, _columnNames);
    }

    @Override
    public ResultSet executeQuery(String _sqlString) throws SQLException {
        return this.statement.executeQuery(_sqlString);
    }

    @Override
    public void clearDefines() throws SQLException {
        this.statement.clearDefines();
    }

    @Override
    public void defineColumnType(int paramIndex, int _type) throws SQLException {
        this.statement.defineColumnType(paramIndex, _type);
    }

    @Override
    public void defineColumnType(int paramIndex, int _type, int max_length) throws SQLException {
        this.statement.defineColumnType(paramIndex, _type, max_length);
    }

    @Override
    public void defineColumnType(int paramIndex, int _type, int max_length, short formOfUse) throws SQLException {
        this.statement.defineColumnType(paramIndex, _type, max_length, formOfUse);
    }

    @Override
    public void defineColumnTypeBytes(int paramIndex, int _type, int max_length) throws SQLException {
        this.statement.defineColumnTypeBytes(paramIndex, _type, max_length);
    }

    @Override
    public void defineColumnTypeChars(int paramIndex, int _type, int max_length) throws SQLException {
        this.statement.defineColumnTypeChars(paramIndex, _type, max_length);
    }

    @Override
    public void defineColumnType(int paramIndex, int _type, String typeName) throws SQLException {
        this.statement.defineColumnType(paramIndex, _type, typeName);
    }

    @Override
    public int getRowPrefetch() {
        return this.statement.getRowPrefetch();
    }

    @Override
    public void setRowPrefetch(int _prefetch) throws SQLException {
        this.statement.setRowPrefetch(_prefetch);
    }

    @Override
    public int getLobPrefetchSize() throws SQLException {
        return this.statement.getLobPrefetchSize();
    }

    @Override
    public void setLobPrefetchSize(int value) throws SQLException {
        this.statement.setLobPrefetchSize(value);
    }

    @Override
    public int creationState() {
        return this.statement.creationState();
    }

    @Override
    public boolean isNCHAR(int columnIndex) throws SQLException {
        return this.statement.isNCHAR(columnIndex);
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration _registration) throws SQLException {
        this.statement.setDatabaseChangeRegistration(_registration);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        this.statement.setPoolable(isPoolable);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.statement.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.statement.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.statement.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.statement.getLargeMaxRows();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.statement.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.statement.setLargeMaxRows(max);
    }

    @Override
    public void setFixedString(boolean value) {
        this.statement.setFixedString(value);
    }

    @Override
    public boolean getFixedString() {
        return this.statement.getFixedString();
    }

    @Override
    public int sendBatch() throws SQLException {
        return this.statement.sendBatch();
    }

    @Override
    public boolean getserverCursor() {
        return this.statement.getserverCursor();
    }

    @Override
    public int getcacheState() {
        return this.statement.getcacheState();
    }

    @Override
    public int getstatementType() {
        return this.statement.getstatementType();
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        return this.statement.getRegisteredTableNames();
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        return this.statement.getRegisteredQueryId();
    }

    @Override
    public String getSqlId() throws SQLException {
        return this.statement.getSqlId();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public void setSnapshotSCN(long scn) throws SQLException {
        this.statement.setSnapshotSCN(scn);
    }

    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        return this.statement == closedStatement ? this.sqlKind : this.statement.getSqlKind();
    }

    @Override
    public long getChecksum() throws SQLException {
        if (this.statement != closedStatement) {
            return this.statement.getChecksum();
        }
        if (this.checkSumComputationFailure) {
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getChecksum").fillInStackTrace();
        }
        return this.checkSum;
    }

    @Override
    public void registerBindChecksumListener(OracleStatement.BindChecksumListener value) throws SQLException {
        this.statement.registerBindChecksumListener(value);
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public long getQueryId() throws SQLException {
        return this.statement.getQueryId();
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.statement.getCompileKey();
    }

    @Override
    public boolean isSimpleIdentifier(String val) throws SQLException {
        return this.statement.isSimpleIdentifier(val);
    }

    @Override
    public String enquoteIdentifier(String val, boolean alwaysQuote) throws SQLException {
        return this.statement.enquoteIdentifier(val, alwaysQuote);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return this.statement.enquoteLiteral(val);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return this.statement.enquoteNCharLiteral(val);
    }

    @Override
    public void setShardingKeyRpnTokens(byte[] shardingKeyRpnTokens) throws SQLException {
        this.statement.setShardingKeyRpnTokens(shardingKeyRpnTokens);
    }

    @Override
    public byte[] getShardingKeyRpnTokens() throws SQLException {
        return this.statement.getShardingKeyRpnTokens();
    }

    @Override
    public long getSSSCursorChecksum() throws SQLException {
        return this.statement.getSSSCursorChecksum();
    }

    @Override
    public void setSSSCursorPosition(long pos) throws SQLException {
        this.statement.setSSSCursorPosition(pos);
    }

    @Override
    public boolean allRowsFetched() throws SQLException {
        return this.statement.allRowsFetched();
    }

    @Override
    public void markSSSCursor() throws SQLException {
        this.statement.markSSSCursor();
    }

    @Override
    public boolean isAutoKeyUsed() throws SQLException {
        return this.statement.isAutoKeyUsed();
    }

    @Override
    public String getOriginalSql() throws SQLException {
        return this.statement.getOriginalSql();
    }

    @Override
    public boolean doesBatchExist() throws SQLException {
        return this.statement.doesBatchExist();
    }

    @Override
    public OracleConnection getInternalConnection() throws SQLException {
        return this.statement.getInternalConnection();
    }

    @Override
    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        return this.statement.copyBinds(toStmt, offset);
    }

    @Override
    public void setLongPrefetch(boolean isEnabled) {
        this.statement.setLongPrefetch(isEnabled);
    }

    @Override
    public void setRowDataLimit(long numBytes) throws SQLException {
        this.statement.setRowDataLimit(numBytes);
    }
}

