/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

abstract class DatumBinder
extends Binder {
    byte[] paramVal;
    boolean skipBindChecksumForLobs = false;
    ByteBuffer lobData = null;

    DatumBinder(byte[] val) {
        this.paramVal = val;
    }

    DatumBinder(byte[] val, ByteBuffer data) {
        this.paramVal = val;
        this.lobData = data;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        ByteBuffer data = this.lobData;
        if (clearPriorBindValues) {
            this.paramVal = null;
            this.lobData = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int len = value.length;
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                bindData.put(value, 0, len);
                if (data != null) {
                    int dataLength = data.remaining();
                    bindData.put(data.array(), 0, dataLength);
                    bindDataLengths[bindDataIndex] = len + dataLength;
                    stmt.lastBoundDataLengths[bindPosition] = len + dataLength;
                } else {
                    bindDataLengths[bindDataIndex] = len;
                    stmt.lastBoundDataLengths[bindPosition] = len;
                }
            } else {
                System.arraycopy(value, 0, bindBytes, byteoffset, value.length);
            }
            bindIndicators[lenoffset] = (short)len;
        }
        if (!this.skipBindChecksumForLobs && stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, this.paramVal, internalType, null, 0);
    }
}

