/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.internal.Monitor;

public class OracleConversionInputStreamInternal
extends OracleConversionInputStream {
    private static final String CLASS_NAME = OracleConversionInputStreamInternal.class.getName();
    private boolean needReset = false;
    private static final Monitor monitor = Monitor.newInstance();

    public OracleConversionInputStreamInternal(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        super(conv_object, istream, conversion, max_bytesize, monitor);
    }

    public OracleConversionInputStreamInternal(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        super(conv_object, reader, conversion, max_charsize, formOfUse, monitor);
    }

    @Override
    public int read(byte[] destbuf, int offset, int length) throws IOException {
        int ret;
        if (this.needReset) {
            if (this.istream != null && this.istream.markSupported()) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "End Of Stream reached , resetting for internally created stream. {0}", (String)null, (Throwable)null, (Object)this);
                this.istream.reset();
                this.resetStream();
            } else if (this.reader != null && this.reader.markSupported()) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "End Of reader reached , resetting for internally created reader. {0}", (String)null, (Throwable)null, (Object)this);
                this.reader.reset();
                this.resetStream();
            }
        }
        if ((ret = super.read(destbuf, offset, length)) == -1) {
            this.needReset = true;
        }
        return ret;
    }

    private void resetStream() {
        this.endOfStream = false;
        this.totalSize = 0;
        this.currentBufferSize = this.initialBufferSize;
        this.needReset = false;
    }
}

