/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.OsonConverter;
import oracle.jdbc.spi.OsonProvider;

public class DefaultOsonProvider
implements OsonProvider {
    private static final String JACKSON_PROVIDER_NAME = "jackson-oson-provider";
    private OsonConverter osonConverter = NO_OP_OSON_CONVERTER;
    public static final OsonConverter NO_OP_OSON_CONVERTER = new OsonConverter(){

        @Override
        public byte[] getOson(Object object) throws IllegalStateException {
            return null;
        }

        @Override
        public Object getObject(byte[] osonBytes, Class<?> type) throws IllegalStateException {
            return null;
        }
    };

    @Override
    public String getName() {
        return "ojdbc-default-oson-provider";
    }

    @Override
    public OsonConverter getOsonConverter(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        try {
            ServiceLoader<OsonProvider> serviceLoader = ServiceLoader.load(ResourceType.OSON_PROVIDER.getProviderClass());
            for (OsonProvider provider : serviceLoader) {
                String name = provider.getName();
                if (name == null || !name.equals(JACKSON_PROVIDER_NAME)) continue;
                this.osonConverter = provider.getOsonConverter(parameterValues);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        return this.osonConverter;
    }
}

