/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIOControlPacket;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.NetworkCompressionCodec;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpsNTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class SessionAtts
implements SQLnetDef {
    private static final Predicate<String> IS_PASSWORD = Pattern.compile(".*password.*", 2).asPredicate();
    private static final Predicate<String> IS_VALID_CONNECTION_ID_PREFIX = Pattern.compile("[A-z0-9,_]{8}").asPredicate();
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    protected String connectData;
    public boolean anoActive;
    protected boolean isLargeSDU = false;
    protected int negotiatedSDU = -1;
    protected boolean redirecting = false;
    protected boolean isJavaNetNIO = false;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    NIOControlPacket controlPacket;
    NTAdapter.NetworkAdapterType networkType;
    public ByteBuffer readBuffer = null;
    public ByteBuffer payloadDataBufferForRead = null;
    ByteBuffer payloadBufferForRead = null;
    ByteBuffer headerBufferForRead = null;
    public ByteBuffer writeBuffer = null;
    public ByteBuffer payloadDataBufferForWrite = null;
    ByteBuffer payloadBufferForWrite = null;
    ByteBuffer headerBufferForWrite = null;
    boolean useNativeBuffers = false;
    boolean needToReleaseMSGQBuffer = false;
    private final Properties netProperties = new Properties();
    String networkCompression;
    ArrayList<String> networkCompressionLevelsArray;
    int networkCompressionThreshold;
    String negotiatedNetworkCompression;
    boolean networkCompressionEnabled;
    int negotiatedNetworkCompressionScheme;
    NetworkCompressionCodec compressionCodec;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    boolean needsToBeClosed;
    boolean isPollAndCheckEnabled;
    static int DEFAULT_POLL_AND_CHECK_TIME_MILLIS = 60000;
    final Monitor ntOutputStreamMonitor = Monitor.newInstance();
    private final SecuredLogger securedLogger;
    private final String uniqueConnectionId;
    private String netConnectionId;
    private String netConnectionIdPrefix;
    String traceId;

    public SessionAtts(NSProtocol nSProtocol, int n2, int n3, boolean bl, boolean bl2, SecuredLogger securedLogger) {
        this.sdu = n2;
        this.tdu = n3;
        this.ns = nSProtocol;
        this.securedLogger = securedLogger;
        this.anoActive = false;
        this.connected = false;
        this.netConnectionId = this.uniqueConnectionId = this.createUniqueConnectionId();
        if (bl) {
            this.dataChannel = new NIONSDataChannel(this);
            this.markerPacket = new NIOMarkerPacket(this);
            this.ddPacket = new NIODataDescriptorPacket(this);
            this.controlPacket = new NIOControlPacket(this);
            this.useNativeBuffers = bl2;
            this.isJavaNetNIO = true;
        }
    }

    public SecuredLogger getSecuredLogger() {
        return this.securedLogger;
    }

    public boolean isConnected() {
        return this.connected;
    }

    void setNetProperty(String string, String string2) {
        this.netProperties.setProperty(string, string2);
    }

    public String getNetProperty(String string) {
        return this.netProperties.getProperty(string);
    }

    public String getNetConnectionId() {
        return this.netConnectionId;
    }

    private String createUniqueConnectionId() {
        try {
            UUID uUID = UUID.randomUUID();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
            return Base64.getEncoder().encodeToString(byteBuffer.array());
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to generate ConnectionID to establish Connection", exception);
        }
    }

    void setNetConnectionIdPrefix(String string) {
        if (!this.isValidNetConnectionIdPrefix(string)) {
            throw new IllegalArgumentException("Invalid ConnectionId prefix : " + string);
        }
        this.netConnectionIdPrefix = string;
        this.netConnectionId = string == null ? this.uniqueConnectionId : this.netConnectionIdPrefix + this.uniqueConnectionId;
    }

    private boolean isValidNetConnectionIdPrefix(String string) {
        return string == null || IS_VALID_CONNECTION_ID_PREFIX.test(string);
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getNetProperties() {
        return (Properties)this.netProperties.clone();
    }

    void initializeNetProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException, IOException {
        properties.stringPropertyNames().stream().filter(IS_PASSWORD.negate()).forEach(string -> this.netProperties.put(string, properties.get(string)));
        this.setNetProperty("oracle.jdbc.negotiatedCompressionStatus", this.networkCompressionEnabled + "");
        this.setNetProperty("oracle.jdbc.negotiatedSDU", this.getSDU() + "");
        this.setNetProperty("oracle.jdbc.negotiatedTDU", this.getTDU() + "");
        this.setNetProperty("oracle.jdbc.connectedNetworkAddress", this.cOption.addr);
        this.setNetProperty("oracle.net.CONNECT_TIMEOUT", this.cOption.transportConnectTimeout + "");
        this.setNetProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", this.cOption.connectTimeout + "");
        if (this.nt.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS) {
            this.setNetProperty("oracle.jdbc.negotiatedCipherSuite", (String)this.nt.getOption(105));
        }
        if (this.ano != null) {
            if (this.isChecksumActive) {
                this.setNetProperty("oracle.jdbc.negotiatedChecksumAlgorithm", this.ano.getDataIntegrityName());
            }
            if (this.isEncryptionActive) {
                this.setNetProperty("oracle.jdbc.negotiatedEncryptionAlgorithm", this.ano.getEncryptionName());
            }
            if (!this.ano.getAuthenticationAdaptorName().equals("")) {
                this.setNetProperty("oracle.jdbc.negotiatedAuthenticationAdaptor", this.ano.getAuthenticationAdaptorName());
            }
        }
    }

    protected void initializeBuffer(int n2) throws IOException {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            this.initializeBufferForMSGQ();
        } else {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).setBufferSize(this.getSDU());
            }
            if (this.useNativeBuffers) {
                this.setWriteBuffer(ByteBuffer.allocateDirect(n2));
                this.setReadBuffer(ByteBuffer.allocateDirect(n2));
            } else {
                this.setWriteBuffer(ByteBuffer.allocate(n2));
                this.setReadBuffer(ByteBuffer.allocate(n2));
            }
        }
    }

    private void initializeBufferForMSGQ() {
        if (this.writeBuffer != null) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
        ((MQLNTAdapter)this.nt).setNegotiatedSDUAndTDU(this.sdu, this.tdu);
    }

    void resetWriteBuffersForMSGQ() {
        this.writeBuffer = null;
    }

    void setWriteBuffer(ByteBuffer byteBuffer) {
        this.writeBuffer = byteBuffer;
        this.sliceWriteBuffers();
    }

    void setReadBuffer(ByteBuffer byteBuffer) {
        this.readBuffer = byteBuffer;
        this.sliceReadBuffers();
    }

    void releaseWriteBuffer() {
        if (this.writeBuffer == null) {
            return;
        }
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.writeBuffer = null;
    }

    void sliceWriteBuffers() {
        this.writeBuffer.clear();
        this.writeBuffer.limit(8);
        this.headerBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(8);
        this.writeBuffer.limit(this.sdu);
        this.payloadBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(10);
        this.payloadDataBufferForWrite = this.writeBuffer.slice();
        this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        this.payloadDataBufferForWrite.order(this.byteOrder);
        this.writeBuffer.rewind();
    }

    void sliceReadBuffers() {
        this.readBuffer.position(0);
        this.headerBufferForRead = this.readBuffer.slice();
        if (this.readBuffer.limit() >= 8) {
            this.readBuffer.position(8);
            this.payloadBufferForRead = this.readBuffer.slice();
        }
        if (this.readBuffer.limit() >= 10) {
            this.readBuffer.position(10);
            this.payloadDataBufferForRead = this.readBuffer.slice();
            this.payloadDataBufferForRead.order(this.byteOrder);
            this.payloadBufferForRead.rewind();
        }
        this.readBuffer.rewind();
    }

    public void prepareWriteBuffer() {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            if (this.writeBuffer != null) {
                this.sliceWriteBuffers();
            } else {
                this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
            }
        } else {
            this.payloadDataBufferForWrite.clear();
            this.payloadBufferForWrite.clear();
            this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
            this.payloadBufferForWrite.limit(this.payloadBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setSDU(int n2) {
        this.sdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 512 ? 512 : n2))) : (n2 <= 0 ? 8192 : (n2 > 0x200000 ? 0x200000 : (n2 < 512 ? 512 : n2)));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int n2) {
        this.tdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 255 ? 255 : n2))) : (n2 <= 0 ? 0x200000 : (n2 > 0x200000 ? 0x200000 : (n2 < 255 ? 255 : n2)));
    }

    public int getTDU() {
        return this.tdu;
    }

    void setNegotiatedSDUAndTDU(int n2, int n3) throws IOException {
        this.setTDU(n3);
        if (n3 < n2) {
            this.setSDU(n3);
        } else {
            this.setSDU(n2);
        }
        this.negotiatedSDU = this.sdu;
        this.initializeBuffer(this.getSDU());
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        if (this.isJavaNetNIO) {
            this.socketChannel = this.nt.getSocketChannel();
        } else {
            this.ntInputStream = this.nt.getInputStream();
            this.ntOutputStream = this.nt.getOutputStream();
        }
    }

    @DisableTrace
    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream == null || netOutputStream == null) {
            throw new NetException(300);
        }
        this.nsInputStream = netInputStream;
        this.nsOutputStream = netOutputStream;
        this.anoActive = true;
    }

    public void turnEncryptionOn(NIONSDataChannel nIONSDataChannel) throws NetException {
        if (nIONSDataChannel == null) {
            throw new NetException(300);
        }
        this.dataChannel = nIONSDataChannel;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int n2 = 1;
        if (this.ano != null) {
            n2 = this.ano.getNAFlags();
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int n2) {
        this.negotiatedOptions = n2;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }

    public ConnOption getcOption() {
        return this.cOption;
    }

    void setConnectData(String string) {
        this.connectData = string;
    }

    String getConnectData() {
        return this.connectData;
    }

    final boolean isExpediatedAttentionEnabled() {
        return (this.negotiatedOptions & 0x400) == 1024;
    }

    final boolean isAttentionProcessingEnabled() {
        return (this.negotiatedOptions & 0x800) != 2048;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

