/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.util.HashSet;
import oracle.jdbc.AdditionalDatabaseMetaData;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={DatabaseMetaData.class, ParameterMetaData.class, ResultSetMetaData.class, RowId.class, SQLData.class, SQLInput.class, SQLXML.class, AdditionalDatabaseMetaData.class, OracleParameterMetaData.class, OracleResultSetMetaData.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, oracle.jdbc.internal.OracleResultSetMetaData.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableBase
implements Replayable,
InvocationHandler,
Monitor {
    protected FailoverManagerImpl failoverMngr;
    protected FailoverManagerImpl.CallHistoryEntry headSameProxy = null;
    protected FailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
    protected FailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
    protected SQLRecoverableException originalError = null;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE1 = 603;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE2 = 29791;
    protected boolean isClosedAndNoReplay = false;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.failoverMngr.record(this, method, objectArray, "started");
                break;
            }
        }
    }

    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Post
    protected Object postForAll(Method method, Object object) {
        Object object2;
        if (object instanceof NonTxnReplayableBase) {
            object2 = (NonTxnReplayableBase)object;
            ((NonTxnReplayableBase)object2).setFailoverManager(this.getFailoverManager());
        }
        object2 = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[((Enum)object2).ordinal()]) {
            case 1: 
            case 8: {
                this.doPostWhenRecording(method, object, null);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                this.doPostWhenReplaying(method, object, null);
            }
        }
        return object;
    }

    protected void doPostWhenRecording(Method method, Object object, SQLException sQLException) {
        this.failoverMngr.update(this, null, object, "completed", 0L, -1L, sQLException);
    }

    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        if (sQLException instanceof SQLRecoverableException) {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: {
                    return this.failoverMngr.replayAll((SQLRecoverableException)sQLException);
                }
            }
            throw sQLException;
        }
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecording(method, null, sQLException);
                break;
            }
        }
        throw sQLException;
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object;
        Object object2 = null;
        try {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle;
            ((Replayable)callHistoryEntry.jdbcProxy).setReplayingCallContext(callHistoryEntry, sQLRecoverableException);
            object2 = object = callHistoryEntry.method.invoke(callHistoryEntry.jdbcProxy, callHistoryEntry.args);
            if (object instanceof NonTxnReplayableBase && (replayLifecycle = this.failoverMngr.getReplayLifecycle()) == FailoverManagerImpl.ReplayLifecycle.REPLAYING && object != null && callHistoryEntry.result != null) {
                Object object3 = ((NonTxnReplayableBase)object).getDelegate();
                ((NonTxnReplayableBase)callHistoryEntry.result).setDelegate(object3);
                object2 = callHistoryEntry.result;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SQLRecoverableException) {
                SQLRecoverableException sQLRecoverableException2 = (SQLRecoverableException)throwable;
                throw sQLRecoverableException2;
            }
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                int n2 = sQLException.getErrorCode();
                if (n2 == 29791) {
                    this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 390, "Replay failed because of active transaction during replay", sQLRecoverableException);
                } else if (callHistoryEntry.callException == null || n2 != callHistoryEntry.callException.getErrorCode()) {
                    this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 389, "Replay failed because of error code or message mismatch", sQLRecoverableException);
                }
            } else {
                this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 370, "Replay disabled", sQLRecoverableException);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 370, "Replay disabled", sQLRecoverableException);
        }
        object = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[((Enum)object).ordinal()]) {
            case 2: 
            case 4: {
                this.failoverMngr.throwReplayExceptionInternal(0, null, null);
            }
        }
        return object2;
    }

    @Override
    public void addToSameProxyList(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntrySameProxy = this.tailSameProxy;
        callHistoryEntry.nextEntrySameProxy = null;
        if (this.tailSameProxy != null) {
            this.tailSameProxy.nextEntrySameProxy = callHistoryEntry;
        }
        this.tailSameProxy = callHistoryEntry;
        if (this.headSameProxy == null) {
            this.headSameProxy = callHistoryEntry;
        }
    }

    @Override
    public void removeFromSameProxyList(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntrySameProxy != null) {
            callHistoryEntry.nextEntrySameProxy.prevEntrySameProxy = callHistoryEntry.prevEntrySameProxy;
        }
        if (callHistoryEntry.prevEntrySameProxy != null) {
            callHistoryEntry.prevEntrySameProxy.nextEntrySameProxy = callHistoryEntry.nextEntrySameProxy;
        }
        if (this.headSameProxy == callHistoryEntry) {
            this.headSameProxy = callHistoryEntry.nextEntrySameProxy;
        }
        if (this.tailSameProxy == callHistoryEntry) {
            this.tailSameProxy = callHistoryEntry.prevEntrySameProxy;
        }
    }

    @Override
    public void purgeSameProxyList() {
        if (this.failoverMngr != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object = this; object != null && object instanceof NonTxnReplayableBase && !(object instanceof ReplayableConnection); object = ((NonTxnReplayableBase)object).getCreator()) {
                hashSet.add(object);
            }
            this.failoverMngr.purgeForSameProxy(hashSet, this.headSameProxy);
        }
    }

    @Override
    public void setReplayingCallContext(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) {
        this.replayingCallEntry = callHistoryEntry;
        this.originalError = sQLRecoverableException;
    }

    @Override
    public void setFailoverManager(FailoverManagerImpl failoverManagerImpl) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.failoverMngr = failoverManagerImpl;
        }
    }

    @Override
    public FailoverManagerImpl getFailoverManager() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            FailoverManagerImpl failoverManagerImpl = this.failoverMngr;
            return failoverManagerImpl;
        }
    }

    private boolean isReplayFailure(Throwable throwable) {
        int n2;
        boolean bl = false;
        if (throwable instanceof SQLException && (n2 = ((SQLException)throwable).getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    protected boolean assertThrowablesMatch(Throwable throwable, Throwable throwable2) {
        boolean bl;
        boolean bl2 = throwable2 == null ? false : throwable.getClass().getName().equals(throwable2.getClass().getName());
        if (throwable instanceof SQLException && bl2) {
            bl = ((SQLException)throwable).getErrorCode() == ((SQLException)throwable2).getErrorCode();
        } else if (bl2) {
            String string = throwable.getMessage();
            String string2 = throwable2.getMessage();
            bl = string == null && string2 == null || string != null && string2 != null && throwable.getMessage().equals(throwable2.getMessage());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

