/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class NativeImageFeature
implements Feature {
    private ResourcesRegistry resourcesRegistry;

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        Class parserFactory;
        Class characterConverterOGS = a.findClassByName("oracle.i18n.text.converter.CharacterConverterOGS");
        if (characterConverterOGS != null) {
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverterOGS");
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverterSJIS");
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverter12Byte");
        }
        if ((parserFactory = a.findClassByName("oracle.xml.jaxp.JXSAXParserFactory")) != null) {
            this.getResourceRegistry().addResourceBundles("oracle.xml.mesg.XMLResourceBundle");
        }
    }

    private void initializeAtBuildTime(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{clazz});
        }
    }

    private void registerAll(Feature.BeforeAnalysisAccess a, String className) {
        this.registerClass(a, className);
        this.registerAllConstructor(a, className);
        this.registerAllMethods(a, className);
        this.registerAllFields(a, className);
    }

    private void registerClass(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Constructor<?> c : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{c});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Method m : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{m});
            }
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Field f : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{f});
            }
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }
}

