/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.InterruptedIOException;
import java.nio.channels.SocketChannel;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public final class TimeoutInterruptHandler {
    private static final Timer INTERRUPT_TIMER = new Timer("InterruptTimer", true);
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash = new ConcurrentHashMap();
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash = new ConcurrentHashMap();

    private TimeoutInterruptHandler() {
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread, SocketChannel socketChannel, boolean bl) {
        if (n2 <= 0) {
            return null;
        }
        ConcurrentHashMap<Thread, InterruptTask> concurrentHashMap = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = (InterruptTask)concurrentHashMap.get(thread);
        if (interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(interruptTaskType, thread);
        }
        interruptTask = new InterruptTask(thread, n2, socketChannel, bl);
        INTERRUPT_TIMER.schedule((TimerTask)interruptTask, n2);
        concurrentHashMap.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread, SocketChannel socketChannel) {
        return TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, n2, thread, socketChannel, false);
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread) {
        return TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, n2, thread, null);
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType interruptTaskType, Thread thread) {
        ConcurrentHashMap<Thread, InterruptTask> concurrentHashMap = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = (InterruptTask)concurrentHashMap.remove(thread);
        if (interruptTask != null) {
            interruptTask.cancel();
            INTERRUPT_TIMER.purge();
        }
        return interruptTask;
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType interruptTaskType, SocketChannel socketChannel) {
        ConcurrentHashMap<Thread, InterruptTask> concurrentHashMap = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask2 = concurrentHashMap.searchValues(1L, interruptTask -> interruptTask.isSocketChannel(socketChannel) ? interruptTask : null);
        if (interruptTask2 == null) {
            return null;
        }
        concurrentHashMap.remove(interruptTask2.getThread());
        interruptTask2.cancel();
        INTERRUPT_TIMER.purge();
        return interruptTask2;
    }

    public static boolean isInterruptScheduled(InterruptTaskType interruptTaskType, Thread thread) {
        ConcurrentHashMap<Thread, InterruptTask> concurrentHashMap = TimeoutInterruptHandler.getMap(interruptTaskType);
        return concurrentHashMap.get(thread) != null;
    }

    public static void resetTimer(InterruptTaskType interruptTaskType, Thread thread) {
        ConcurrentHashMap<Thread, InterruptTask> concurrentHashMap = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(interruptTaskType, thread);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, interruptTask.time, thread, interruptTask.socketChannel, interruptTask.sendAttn);
        }
    }

    private static ConcurrentHashMap<Thread, InterruptTask> getMap(InterruptTaskType interruptTaskType) {
        if (interruptTaskType.compareTo(InterruptTaskType.OUTBOUND_TIMEOUT) == 0) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        INTERRUPT_TIMER.cancel();
    }

    public static TimerTask scheduleTask(Runnable runnable, long l2) {
        TimerPurgingTask timerPurgingTask = new TimerPurgingTask(runnable);
        INTERRUPT_TIMER.schedule((TimerTask)timerPurgingTask, l2);
        return timerPurgingTask;
    }

    public static TimerTask scheduleFixedDelayRepeatingTask(Runnable runnable, long l2) {
        TimerPurgingTask timerPurgingTask = new TimerPurgingTask(runnable);
        INTERRUPT_TIMER.schedule((TimerTask)timerPurgingTask, 0L, l2);
        return timerPurgingTask;
    }

    public static void scheduleAtFixedRate(TimerTask timerTask, long l2, long l3) {
        INTERRUPT_TIMER.scheduleAtFixedRate(timerTask, l2, l3);
    }

    private static final class TimerPurgingTask
    extends TimerTask {
        private final Runnable runnableTask;
        private boolean isPurged = false;

        private TimerPurgingTask(Runnable runnable) {
            this.runnableTask = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnableTask.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public boolean cancel() {
            boolean bl = super.cancel();
            if (!this.isPurged) {
                INTERRUPT_TIMER.purge();
                this.isPurged = true;
            }
            return bl;
        }
    }

    public static class IOReadTimeoutException
    extends InterruptedIOException {
        private static final long serialVersionUID = 1L;

        IOReadTimeoutException(String string) {
            super(string);
        }
    }

    public static class InterruptTask
    extends TimerTask {
        private final Thread threadTobeInterrupted;
        private boolean isInterrupted = false;
        private final int time;
        private final SocketChannel socketChannel;
        private boolean sendAttn = false;

        public InterruptTask(Thread thread, int n2, SocketChannel socketChannel) {
            this.threadTobeInterrupted = thread;
            this.time = n2;
            this.socketChannel = socketChannel;
        }

        public InterruptTask(Thread thread, int n2, SocketChannel socketChannel, boolean bl) {
            this(thread, n2, socketChannel);
            this.sendAttn = bl;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        public boolean isSocketChannel(SocketChannel socketChannel) {
            return this.socketChannel == socketChannel;
        }

        public Thread getThread() {
            return this.threadTobeInterrupted;
        }

        private void sendAttentionMarker() {
            if (!this.sendAttn) {
                return;
            }
            try {
                this.socketChannel.socket().sendUrgentData(33);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.sendAttentionMarker();
            this.threadTobeInterrupted.interrupt();
        }
    }

    public static enum InterruptTaskType {
        SO_TIMEOUT,
        OUTBOUND_TIMEOUT;

    }
}

