/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;
import java.sql.ShardingKey;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

public abstract class AbstractConnectionBuilder<T extends AbstractConnectionBuilder<T, U>, U> {
    private final T self = this;
    private boolean isImmutable = false;
    private String user = null;
    private OpaqueString password = null;
    private String serviceName = null;
    private String instanceName = null;
    private OracleShardingKey shardingKey = null;
    private OracleShardingKey superShardingKey = null;
    private GSSCredential gssCredential = null;
    private SSLContext sslContext = null;
    private boolean allowSingleShardTransaction = false;
    private boolean readOnlyInstanceAllowed = false;
    private OracleHostnameResolver hostnameResolver = null;
    private Executor executor = null;
    private Supplier<? extends AccessToken> tokenSupplier = null;

    protected AbstractConnectionBuilder() {
    }

    public final T password(@Blind String string) {
        this.ensureMutableState();
        this.password = OpaqueString.newOpaqueString(string);
        return this.self;
    }

    public T password(OpaqueString opaqueString) {
        this.ensureMutableState();
        this.password = opaqueString;
        return this.self;
    }

    public final T user(String string) {
        this.ensureMutableState();
        this.user = string;
        return this.self;
    }

    public final T serviceName(String string) {
        this.ensureMutableState();
        this.serviceName = string;
        return this.self;
    }

    public final T instanceName(String string) {
        this.ensureMutableState();
        this.instanceName = string;
        return this.self;
    }

    public final T shardingKey(OracleShardingKey oracleShardingKey) {
        this.ensureMutableState();
        this.shardingKey = oracleShardingKey;
        return this.self;
    }

    public final T superShardingKey(OracleShardingKey oracleShardingKey) {
        this.ensureMutableState();
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this.self;
    }

    public final T shardingKey(ShardingKey shardingKey) {
        this.ensureMutableState();
        return this.shardingKey((OracleShardingKey)shardingKey);
    }

    public final T superShardingKey(ShardingKey shardingKey) {
        this.ensureMutableState();
        return this.superShardingKey((OracleShardingKey)shardingKey);
    }

    public final T gssCredential(GSSCredential gSSCredential) {
        this.ensureMutableState();
        if (gSSCredential == null) {
            throw new NullPointerException("Argument to gssCredential(GSSCredential) is null");
        }
        this.gssCredential = gSSCredential;
        return this.self;
    }

    public final T sslContext(SSLContext sSLContext) {
        this.ensureMutableState();
        this.sslContext = sSLContext;
        return this.self;
    }

    public final T singleShardTransactionSupport(boolean bl) {
        this.ensureMutableState();
        this.allowSingleShardTransaction = bl;
        return this.self;
    }

    public final T readOnlyInstanceAllowed(boolean bl) {
        this.ensureMutableState();
        this.readOnlyInstanceAllowed = bl;
        return this.self;
    }

    public final T hostnameResolver(OracleHostnameResolver oracleHostnameResolver) {
        this.ensureMutableState();
        this.hostnameResolver = oracleHostnameResolver;
        return this.self;
    }

    public final String getUser() {
        return this.user;
    }

    public final OpaqueString getPassword() {
        return this.password;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public final OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public final GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final boolean getAllowSingleShardTransaction() {
        return this.allowSingleShardTransaction;
    }

    public final boolean getReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    public final OracleHostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    @Blind
    public final Supplier<? extends AccessToken> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public final T copy(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        this.ensureMutableState();
        this.user = abstractConnectionBuilder.user;
        this.password = abstractConnectionBuilder.password;
        this.instanceName = abstractConnectionBuilder.instanceName;
        this.serviceName = abstractConnectionBuilder.serviceName;
        this.shardingKey = abstractConnectionBuilder.shardingKey;
        this.superShardingKey = abstractConnectionBuilder.superShardingKey;
        this.sslContext = abstractConnectionBuilder.sslContext;
        this.hostnameResolver = abstractConnectionBuilder.hostnameResolver;
        this.allowSingleShardTransaction = abstractConnectionBuilder.allowSingleShardTransaction;
        this.executor = abstractConnectionBuilder.executor;
        this.tokenSupplier = abstractConnectionBuilder.tokenSupplier;
        if (this.gssCredential != null) {
            this.gssCredential = abstractConnectionBuilder.gssCredential;
        }
        return this.self;
    }

    public final T executorOracle(Executor executor) {
        this.ensureMutableState();
        this.executor = executor;
        return this.self;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public final T accessToken(@Blind AccessToken accessToken) {
        Objects.requireNonNull(accessToken, "Value of accessToken is null");
        this.setTokenSupplier(() -> accessToken);
        return this.self;
    }

    public final void setTokenSupplier(@Blind Supplier<? extends AccessToken> supplier) {
        this.tokenSupplier = supplier;
    }

    public final void verifyBuildConfiguration() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.getUser() != null || this.getPassword() != null && !this.getPassword().isNull();
        if (this.getGSSCredential() != null && bl) {
            throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
        }
        if (this.tokenSupplier != null && bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Builder is configured with both an access token and a user name or password").fillInStackTrace();
        }
    }

    public abstract U build() throws SQLException;

    protected final void setImmutable() {
        this.isImmutable = true;
    }

    protected final void ensureMutableState() {
        if (this.isImmutable) {
            throw new IllegalStateException("This builder is immutable");
        }
    }

    public static <T extends AbstractConnectionBuilder<T, U>, U> AbstractConnectionBuilder<T, U> unconfigured() {
        return new AbstractConnectionBuilder<T, U>(){

            @Override
            public U build() throws SQLException {
                throw new IllegalStateException();
            }
        };
    }
}

