/*
 * Decompiled with CFR 0.152.
 */
package oracle.simplefan.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.simplefan.FanEvent;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.impl.LoadAdvisoryEvent;
import oracle.simplefan.impl.NodeDownEvent;
import oracle.simplefan.impl.ServiceDownEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FanEventFactory {
    static final Logger logger = Logger.getLogger("oracle.simplefan.FanEventFactory");
    static final String EVENT_TYPE_SERVICE_COMPOSITE = "database/event/service";
    static final String EVENT_TYPE_SERVICE_MEMBER = "database/event/servicemember/";
    static final String EVENT_TYPE_NODE = "database/event/host";
    static final String EVENT_TYPE_SERVICE_METRICS = "database/event/servicemetrics/";
    static final String STATUS_DOWN = "down";
    static final String STATUS_NODE_DOWN = "nodedown";
    static final List<FanEvent> emptyList = new ArrayList<FanEvent>(0);
    static final long millisPerSec = 1000L;

    FanEventFactory() {
    }

    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            Body body = FanEventFactory.parseBody(string.getBytes());
            System.out.println(body.toString());
            System.out.println();
        }
    }

    static List<FanEvent> createFanEvents(Object object, Notification notification) {
        Body body = FanEventFactory.parseBody(notification.body());
        String string = notification.type();
        if (string == null) {
            logger.warning("ONS Notification has null type");
        } else {
            logger.finer("type=\"" + string + "\"");
            if (string.startsWith(EVENT_TYPE_SERVICE_METRICS)) {
                return FanEventFactory.createLoadAdvisoryEvents(object, notification, body);
            }
            if (string.equals(EVENT_TYPE_SERVICE_COMPOSITE) || string.startsWith(EVENT_TYPE_SERVICE_MEMBER)) {
                String string2 = body.getProperty("status");
                logger.finer("status=\"" + string2 + "\"");
                if (STATUS_DOWN.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createServiceDownEvents(object, notification, body);
                }
                logger.finer("service event was not down event");
            } else if (string.equals(EVENT_TYPE_NODE)) {
                if (STATUS_NODE_DOWN.equalsIgnoreCase(body.getProperty("status"))) {
                    return FanEventFactory.createNodeDownEvents(object, notification, body);
                }
                logger.finer("node event was not down event");
            }
        }
        logger.finer("createFanEvents returning empty list");
        return emptyList;
    }

    static List<FanEvent> createLoadAdvisoryEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>();
        logger.finer("creating LoadAdvisoryEvents");
        for (List<Body> list : body) {
            for (Body body2 : list) {
                String string = body2.getProperty("percent");
                String string2 = body2.getProperty("quality");
                arrayList.add(new LoadAdvisoryEvent(object, new Date(notification.creationTime() * 1000L), body.getProperty("service"), body.getProperty("database"), notification.instanceName(), string == null ? -1 : Integer.parseInt(string), string2 == null ? -1 : Integer.parseInt(string2), FanEventFactory.parseLoadStatus(body2.getProperty("status"))));
            }
        }
        return arrayList;
    }

    static List<FanEvent> createServiceDownEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        if (notification.type().equals(EVENT_TYPE_SERVICE_MEMBER)) {
            logger.finer("creating member ServiceDownEvent");
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime() * 1000L), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseReason(body.getProperty("reason")), notification.instanceName(), body.getProperty("host"), false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE)) {
            logger.finer("creating composite ServiceDownEvent");
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime() * 1000L), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseReason(body.getProperty("reason"))));
        } else {
            logger.warning("recevied unknown service event type: \"" + notification.type() + "\"");
            throw new IllegalArgumentException("Unknown service event type: \"" + notification.type() + "\"");
        }
        return arrayList;
    }

    static List<FanEvent> createNodeDownEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        logger.finer("creating NodeDownEvent");
        String string = body.getProperty("incarnation");
        arrayList.add(new NodeDownEvent(object, new Date(notification.creationTime() * 1000L), body.getProperty("host"), string == null ? -1 : Integer.parseInt(string)));
        return arrayList;
    }

    static Body parseBody(byte[] byArray) {
        Body body = new Body();
        FanEventFactory.parseBody(body, byArray, 0);
        return body;
    }

    static int parseBody(Body body, byte[] byArray, int n) {
        logger.finer("parseBody: \"" + new String(byArray) + "\", " + n);
        String string = null;
        String string2 = null;
        int n2 = -1;
        int n3 = n;
        while (n3 < byArray.length) {
            if (byArray[n3] == 32) {
                ++n3;
                continue;
            }
            if (byArray[n3] == 123) {
                n3 = FanEventFactory.parseBodyList(body, byArray, n3 + 1);
                continue;
            }
            if (byArray[n3] == 125) {
                ++n3;
                break;
            }
            n2 = n3;
            while (byArray[n3] != 61) {
                ++n3;
            }
            string = new String(byArray, n2, n3 - n2);
            n2 = ++n3;
            if (string.equals("timestamp")) {
                n3 += 19;
            } else {
                while (n3 < byArray.length && byArray[n3] != 32 && byArray[n3] != 125) {
                    ++n3;
                }
            }
            string2 = new String(byArray, n2, n3 - n2);
            logger.finest("found in body: \"" + string + "\"=\"" + string2 + "\"");
            body.put(string, string2);
        }
        return n3;
    }

    static int parseBodyList(Body body, byte[] byArray, int n) {
        logger.finer("parseBodyList: \"" + new String(byArray) + "\", " + n);
        ArrayList<Body> arrayList = new ArrayList<Body>();
        int n2 = -1;
        int n3 = n;
        while (n3 < byArray.length) {
            if (byArray[n3] == 32) {
                ++n3;
                continue;
            }
            if (byArray[n3] == 123) {
                Body body2 = new Body();
                n3 = FanEventFactory.parseBody(body2, byArray, n3 + 1);
                arrayList.add(body2);
                continue;
            }
            if (byArray[n3] == 125) {
                ++n3;
                break;
            }
            throw new Error("invalid notification syntax at " + n3);
        }
        body.add(arrayList);
        return n3;
    }

    static LoadAdvisoryEvent.LoadStatus parseLoadStatus(String string) {
        logger.finer("parseLoadStatus: \"" + string + "\"");
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("good")) {
            return LoadAdvisoryEvent.LoadStatus.GOOD;
        }
        if (string.equalsIgnoreCase("violating")) {
            return LoadAdvisoryEvent.LoadStatus.VIOLATING;
        }
        if (string.equalsIgnoreCase("NO_DATA")) {
            return LoadAdvisoryEvent.LoadStatus.NO_DATA;
        }
        if (string.equalsIgnoreCase("UNKNOWN")) {
            return LoadAdvisoryEvent.LoadStatus.UNKNOWN;
        }
        logger.warning("unrecognized load status value: \"" + string + "\"");
        throw new IllegalArgumentException("unrecognized load status value: \"" + string + "\"");
    }

    static ServiceDownEvent.Reason parseReason(String string) {
        logger.finer("parseReason: \"" + string + "\"");
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("FAILURE")) {
            return ServiceDownEvent.Reason.FAILURE;
        }
        if (string.equalsIgnoreCase("DEPENDENCY")) {
            return ServiceDownEvent.Reason.DEPENDENCY;
        }
        if (string.equalsIgnoreCase("USER")) {
            return ServiceDownEvent.Reason.USER;
        }
        if (string.equalsIgnoreCase("AUTOSTART")) {
            return ServiceDownEvent.Reason.AUTOSTART;
        }
        if (string.equalsIgnoreCase("BOOT")) {
            return ServiceDownEvent.Reason.BOOT;
        }
        logger.warning("unrecognized reason value: \"" + string + "\"");
        throw new IllegalArgumentException("unrecognized reason value: \"" + string + "\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Body
    implements Iterable<List<Body>> {
        private Properties props = new Properties();
        private List<List<Body>> lists = new ArrayList<List<Body>>();

        Body() {
        }

        void put(String string, String string2) {
            this.props.put(string, string2);
        }

        String getProperty(String string) {
            return this.props.getProperty(string);
        }

        void add(List<Body> list) {
            this.lists.add(list);
        }

        @Override
        public Iterator<List<Body>> iterator() {
            return this.lists.iterator();
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.props.list(printWriter);
            for (List<Body> list : this.lists) {
                printWriter.append("{");
                for (Body body : list) {
                    printWriter.append("{");
                    printWriter.append(body.toString());
                    printWriter.append("}");
                }
                printWriter.append("}");
            }
            return stringWriter.toString();
        }
    }
}

