/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.LinkedList;
import java.util.Queue;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;
import oracle.ons.ServerError;
import oracle.ons.WebSocket;

class MessageReader {
    private byte[] buffer = null;
    private Queue<Notification> messageList = new LinkedList<Notification>();
    private int bend;
    private int pos;
    private int bodypos;
    private int token_state = 0;
    private StringBuilder line;
    private Notification msg = null;
    private WebSocket websocket;
    private String headerName = null;
    private final byte[] saveBuffer = new byte[16384];
    private int tokenStart = 0;
    private int saveEnd = 0;
    private boolean websockActive = false;
    private static final int TOKEN_END = 100;
    private static final int TOKEN_CONTENT = 10;
    private static final int TOKEN_HEADER = 4;
    private static final int TOKEN_INIT = 0;

    MessageReader() {
    }

    public boolean feedBuffer(byte[] buf, int start, int len) {
        this.buffer = buf;
        this.pos = start;
        this.bend = start + len;
        if (this.websockActive) {
            int fpos = this.pos;
            int frames = 0;
            do {
                int offset;
                if ((offset = this.websocket.parseFrame(this.buffer, fpos, this.bend)) > fpos) {
                    int bytes = this.bend - offset;
                    if (bytes != 0) {
                        System.arraycopy(this.buffer, offset, this.buffer, fpos, bytes);
                    }
                    int skipped = offset - fpos;
                    this.bend -= skipped;
                }
                if (this.websocket.frameAvailIn == 0) {
                    if (frames != 0) break;
                    this.pos = 0;
                    this.bend = 0;
                    break;
                }
                ++frames;
            } while ((fpos += this.websocket.frameAvailIn) < this.bend);
        }
        boolean hasMessages = false;
        while (this.pos < this.bend && this.readMessage()) {
            this.msg.deliveryTime = System.currentTimeMillis();
            this.messageList.add(this.msg);
            this.msg = null;
            hasMessages = true;
        }
        this.buffer = null;
        return hasMessages;
    }

    private void saveBuffer() {
        int len = this.pos - this.tokenStart;
        System.arraycopy(this.buffer, this.tokenStart, this.saveBuffer, this.saveEnd, len);
        this.saveEnd += len;
        this.tokenStart = 0;
    }

    private String getLastToken() {
        String str = this.pos > this.tokenStart ? new String(this.buffer, this.tokenStart, this.pos - this.tokenStart - 1, ONSConfiguration.ONS_CHARSET) : "";
        if (this.saveEnd != 0) {
            String sStr = new String(this.saveBuffer, 0, this.saveEnd, ONSConfiguration.ONS_CHARSET);
            this.saveEnd = 0;
            str = sStr + str;
        }
        return str;
    }

    private void startToken() {
        this.tokenStart = this.pos;
    }

    private boolean readMessage() {
        if (this.msg == null) {
            this.msg = new Notification();
            this.token_state = 0;
        }
        this.tokenStart = this.pos;
        block13: while (this.pos < this.bend) {
            switch (this.token_state) {
                case 0: {
                    this.startToken();
                    ++this.token_state;
                }
                case 1: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.msg.method = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 2: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    if (this.msg.method.equals("POST")) {
                        this.msg.verb = this.getLastToken().substring(1);
                    } else if (this.websocket.enabled && !this.websockActive) {
                        this.msg.verb = "status";
                        this.msg.method = this.getLastToken();
                        this.websockActive = true;
                    } else {
                        throw new ServerError("Unexpected non POST message: " + this.msg.method);
                    }
                    this.startToken();
                    ++this.token_state;
                }
                case 3: {
                    if (!this.skipTo('\r')) continue block13;
                    this.token_state = 4;
                }
                case 4: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    ++this.token_state;
                }
                case 5: {
                    if (this.pos == this.bend) continue block13;
                    if (this.buffer[this.pos] == 13) {
                        ++this.pos;
                        this.token_state = 10;
                        continue block13;
                    }
                    this.startToken();
                    ++this.token_state;
                }
                case 6: {
                    if (!this.skipTo(':')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.headerName = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 7: {
                    if (!this.skipTo('\r')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    String headerValue = this.getLastToken();
                    this.msg.put(this.headerName.trim(), headerValue.trim());
                    this.token_state = 4;
                    continue block13;
                }
                case 10: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    if (this.msg.readHelperContentLength > 0) {
                        this.msg.body = new byte[this.msg.readHelperContentLength];
                        this.bodypos = 0;
                        ++this.token_state;
                    } else {
                        this.token_state = 100;
                        return true;
                    }
                }
                case 11: {
                    if (this.pos == this.bend) continue block13;
                    int toRead = Math.min(this.msg.body.length - this.bodypos, this.bend - this.pos);
                    System.arraycopy(this.buffer, this.pos, this.msg.body, this.bodypos, toRead);
                    this.bodypos += toRead;
                    this.pos += toRead;
                    if (this.bodypos != this.msg.body.length) continue block13;
                    this.token_state = 100;
                    return true;
                }
                case 100: {
                    return true;
                }
            }
            throw new ServerError("Message parsing error");
        }
        return false;
    }

    private boolean skipTo(char x) {
        while (this.pos < this.bend && this.buffer[this.pos] != x) {
            ++this.pos;
        }
        if (this.pos != this.bend) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public boolean available() {
        return !this.messageList.isEmpty();
    }

    public Notification peek() {
        return this.messageList.peek();
    }

    public Notification remove() {
        return this.messageList.remove();
    }

    public void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
    }
}

