/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.PerpetualIterator;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Objects;

public class LocalHost
implements Profile,
Option {
    public static final String PROPERTY = "coherence.localhost";
    public static final String PROPERTY_PORT = "coherence.localport";
    private final String m_sAddress;
    private final Iterator<Integer> m_ports;

    private LocalHost(String address, Iterator<Integer> ports) {
        this.m_sAddress = address;
        this.m_ports = ports;
    }

    public String getAddress() {
        return this.m_sAddress;
    }

    public Iterator<Integer> getPorts() {
        return this.m_ports;
    }

    public static LocalHost loopback() {
        return new LocalHost("127.0.0.1", null);
    }

    public static LocalHost of(String address) {
        return new LocalHost(address, null);
    }

    public static LocalHost of(String address, int port) {
        return new LocalHost(address, (Iterator<Integer>)new PerpetualIterator((Object)port));
    }

    public static LocalHost of(String address, Capture<Integer> port) {
        return new LocalHost(address, (Iterator<Integer>)port);
    }

    public static LocalHost of(String address, Iterator<Integer> ports) {
        return new LocalHost(address, ports);
    }

    public static LocalHost of(String address, AvailablePortIterator ports) {
        return new LocalHost(address, (Iterator<Integer>)ports);
    }

    public static LocalHost only() {
        return new LocalHost(null, null);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (this.m_ports != null && !this.m_ports.hasNext()) {
            throw new IllegalStateException("Exhausted the available ports for the LocalHost");
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            if (this.m_sAddress == null && this.m_ports == null) {
                optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)InetAddress.getLoopbackAddress().getHostAddress(), (Option[])new Option[0]));
                optionsByType.add((Option)SystemProperty.of((String)"coherence.ttl", (String)"0", (Option[])new Option[0]));
            } else {
                if (this.m_sAddress != null) {
                    optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.m_sAddress, (Option[])new Option[0]));
                }
                if (this.m_ports != null) {
                    optionsByType.add((Option)SystemProperty.of((String)PROPERTY_PORT, (Object)this.m_ports.next(), (Option[])new Option[0]));
                }
            }
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalHost localHost = (LocalHost)o;
        return Objects.equals(this.m_sAddress, localHost.m_sAddress) && Objects.equals(this.m_ports, localHost.m_ports);
    }

    public int hashCode() {
        return Objects.hash(this.m_sAddress, this.m_ports);
    }

    public String toString() {
        return "LocalHost(address='" + this.m_sAddress + "', ports=" + String.valueOf(this.m_ports) + ")";
    }
}

