/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.text;

import com.google.common.annotations.Beta;
import com.optimaize.langdetect.cybozu.util.CharNormalizer;
import com.optimaize.langdetect.text.TextFilter;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

@Beta
public class TextObject
implements CharSequence,
Appendable {
    @NotNull
    private final TextFilter textFilter;
    @NotNull
    private final StringBuilder stringBuilder;
    private final int maxTextLength;

    public TextObject(@NotNull TextFilter textFilter, int maxTextLength) {
        this.textFilter = textFilter;
        this.maxTextLength = maxTextLength;
        this.stringBuilder = new StringBuilder();
    }

    public TextObject append(Reader reader) throws IOException {
        char[] buf = new char[1024];
        while (reader.ready() && (this.maxTextLength == 0 || this.stringBuilder.length() < this.maxTextLength)) {
            int length = reader.read(buf);
            this.append(String.valueOf(buf, 0, length));
        }
        return this;
    }

    @Override
    public TextObject append(CharSequence text) {
        if (this.maxTextLength > 0 && this.stringBuilder.length() >= this.maxTextLength) {
            return this;
        }
        text = this.textFilter.filter(text);
        char pre = this.stringBuilder.length() == 0 ? (char)'\u0000' : this.stringBuilder.charAt(this.stringBuilder.length() - 1);
        for (int i = 0; i < text.length() && (this.maxTextLength == 0 || this.stringBuilder.length() < this.maxTextLength); ++i) {
            char c = CharNormalizer.normalize(text.charAt(i));
            if (c != ' ' || pre != ' ') {
                this.stringBuilder.append(c);
            }
            pre = c;
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.append(Character.toString(c));
    }

    @Override
    public int length() {
        return this.stringBuilder.length();
    }

    @Override
    public char charAt(int index) {
        return this.stringBuilder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.stringBuilder.subSequence(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return this.stringBuilder.toString();
    }
}

