/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.protos.PrefsProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.Prefs;
import com.opera.core.systems.scope.stp.services.messages.PrefsMessage;
import java.util.List;

public class ScopePrefs
extends AbstractService
implements Prefs {
    public ScopePrefs(ScopeServices services) {
        super(services, "prefs");
        services.setPrefs(this);
    }

    @Override
    public void init() {
    }

    @Override
    public String getPref(String section, String key, PrefsProtos.GetPrefArg.Mode mode) {
        PrefsProtos.GetPrefArg.Builder getPrefBuilder = PrefsProtos.GetPrefArg.newBuilder();
        getPrefBuilder.setSection(section);
        getPrefBuilder.setKey(key);
        getPrefBuilder.setMode(mode);
        UmsProtos.Response response = this.executeMessage(PrefsMessage.GET_PREF, (AbstractMessage.Builder<?>)getPrefBuilder);
        PrefsProtos.PrefValue.Builder prefValueBuilder = PrefsProtos.PrefValue.newBuilder();
        ScopePrefs.buildPayload(response, prefValueBuilder);
        PrefsProtos.PrefValue prefsString = prefValueBuilder.build();
        return prefsString.getValue();
    }

    @Override
    public List<PrefsProtos.Pref> listPrefs(Boolean sort, String section) {
        PrefsProtos.ListPrefsArg.Builder listPrefBuilder = PrefsProtos.ListPrefsArg.newBuilder();
        if (sort != null) {
            listPrefBuilder.setSort(sort);
        }
        if (section != null && !"".equals(section)) {
            listPrefBuilder.setSection(section);
        }
        UmsProtos.Response response = this.executeMessage(PrefsMessage.LIST_PREFS, (AbstractMessage.Builder<?>)listPrefBuilder);
        PrefsProtos.PrefList.Builder prefListBuilder = PrefsProtos.PrefList.newBuilder();
        ScopePrefs.buildPayload(response, prefListBuilder);
        PrefsProtos.PrefList prefList = prefListBuilder.build();
        return prefList.getPrefListList();
    }

    @Override
    public void setPrefs(String section, String key, String value) {
        PrefsProtos.SetPrefArg.Builder setPrefBuilder = PrefsProtos.SetPrefArg.newBuilder();
        setPrefBuilder.setSection(section);
        setPrefBuilder.setKey(key);
        setPrefBuilder.setValue(value);
        UmsProtos.Response response = this.executeMessage(PrefsMessage.SET_PREF, (AbstractMessage.Builder<?>)setPrefBuilder);
        if (response == null) {
            throw new ScopeException("Internal error while setting a preference");
        }
    }
}

