/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public abstract class CallbackWait {
    private final Clock clock;
    private final Sleeper sleeper;
    private Duration timeout = FluentWait.FIVE_HUNDRED_MILLIS;
    private Duration interval = OperaIntervals.INTERNAL_FREQUENCY.getValue();
    private String message = null;
    private List<Class<? extends RuntimeException>> ignoredExceptions = Lists.newLinkedList();

    public CallbackWait() {
        this((Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER);
    }

    public CallbackWait(Clock clock, Sleeper sleeper) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    public CallbackWait withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public CallbackWait withMessage(String message) {
        this.message = message;
        return this;
    }

    public CallbackWait pollingEvery(Duration interval) {
        this.interval = interval;
        return this;
    }

    public CallbackWait ignoreAll(Collection<Class<? extends RuntimeException>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public CallbackWait ignoring(Class<? extends RuntimeException> exceptionType) {
        return this.ignoreAll((Collection<Class<? extends RuntimeException>>)ImmutableList.of(exceptionType));
    }

    public CallbackWait ignoring(Class<? extends RuntimeException> firstType, Class<? extends RuntimeException> secondType) {
        return this.ignoreAll((Collection<Class<? extends RuntimeException>>)ImmutableList.of(firstType, secondType));
    }

    public <X> X until(Callable<X> condition) {
        long end = this.clock.laterBy(this.timeout.in(TimeUnit.MILLISECONDS));
        Exception lastException = null;
        while (true) {
            try {
                X toReturn = condition.call();
                if (toReturn != null && Boolean.class.equals(toReturn.getClass()) ? Boolean.TRUE.equals(toReturn) : toReturn != null) {
                    return toReturn;
                }
            }
            catch (Exception e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (!this.clock.isNowBefore(end)) {
                String toAppend = this.message == null ? " waiting for " + condition.toString() : ": " + this.message;
                String timeoutMessage = String.format("Timed out after %d milliseconds%s", this.timeout.in(TimeUnit.MILLISECONDS), toAppend);
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.sleeper.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private Exception propagateIfNotIgnored(Exception e) {
        for (Class<? extends RuntimeException> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        throw new TimeoutException((Throwable)e);
    }

    protected RuntimeException timeoutException(String message, Exception lastException) {
        throw new TimeoutException(message, (Throwable)lastException);
    }
}

