/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.ognl.StaticMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.logging.LoggerUtils;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import ognl.TypeConverter;

public class OgnlValueStack
implements Serializable,
ValueStack {
    private static final long serialVersionUID = 370737852934925530L;
    private static Logger LOG = LoggerFactory.getLogger(OgnlValueStack.class);
    private boolean devMode;
    CompoundRoot root;
    transient Map context;
    Class defaultType;
    Map overrides;
    transient OgnlUtil ognlUtil;
    private static final String MAP_IDENTIFIER_KEY = "com.opensymphony.xwork2.util.OgnlValueStack.MAP_IDENTIFIER_KEY";

    public static void link(Map context, Class clazz, String name) {
        context.put("__link", new Object[]{clazz, name});
    }

    protected OgnlValueStack(XWorkConverter xworkConverter, CompoundRootAccessor accessor, TextProvider prov, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(), allowStaticAccess);
        this.push(prov);
    }

    protected OgnlValueStack(ValueStack vs, XWorkConverter xworkConverter, CompoundRootAccessor accessor, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(vs.getRoot()), allowStaticAccess);
    }

    @Inject
    public void setOgnlUtil(OgnlUtil ognlUtil) {
        this.ognlUtil = ognlUtil;
    }

    protected void setRoot(XWorkConverter xworkConverter, CompoundRootAccessor accessor, CompoundRoot compoundRoot, boolean allowStaticMethodAccess) {
        this.root = compoundRoot;
        this.context = Ognl.createDefaultContext((Object)this.root, (ClassResolver)accessor, (TypeConverter)new OgnlTypeConverterWrapper(xworkConverter), (MemberAccess)new StaticMemberAccess(allowStaticMethodAccess));
        this.context.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", this);
        Ognl.setClassResolver((Map)this.context, (ClassResolver)accessor);
        ((OgnlContext)this.context).setTraceEvaluations(false);
        ((OgnlContext)this.context).setKeepLastEvaluation(false);
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equalsIgnoreCase(mode);
    }

    public Map getContext() {
        return this.context;
    }

    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    public void setExprOverrides(Map overrides) {
        if (this.overrides == null) {
            this.overrides = overrides;
        } else {
            this.overrides.putAll(overrides);
        }
    }

    public Map getExprOverrides() {
        return this.overrides;
    }

    public CompoundRoot getRoot() {
        return this.root;
    }

    public void setValue(String expr, Object value) {
        this.setValue(expr, value, this.devMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        Map context = this.getContext();
        try {
            context.put("conversion.property.fullName", expr);
            context.put("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp", throwExceptionOnFailure ? Boolean.TRUE : Boolean.FALSE);
            this.ognlUtil.setValue(expr, context, this.root, value);
        }
        catch (OgnlException e) {
            if (throwExceptionOnFailure) {
                e.printStackTrace(System.out);
                System.out.println("expr: " + expr + " val: " + value + " context: " + context + " root:" + this.root + " value: " + value);
                String msg = "Error setting expression '" + expr + "' with value '" + value + "'";
                throw new XWorkException(msg, e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error setting value", e, new String[0]);
            }
        }
        catch (RuntimeException re) {
            if (throwExceptionOnFailure) {
                StringBuffer msg = new StringBuffer();
                msg.append("Error setting expression '");
                msg.append(expr);
                msg.append("' with value ");
                if (value instanceof Object[]) {
                    Object[] valueArray = (Object[])value;
                    msg.append("[");
                    for (int index = 0; index < valueArray.length; ++index) {
                        msg.append("'");
                        msg.append(valueArray[index]);
                        msg.append("'");
                        if (index >= valueArray.length + 1) continue;
                        msg.append(", ");
                    }
                    msg.append("]");
                } else {
                    msg.append("'");
                    msg.append(value);
                    msg.append("'");
                }
                throw new XWorkException(msg.toString(), re);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error setting value", re, new String[0]);
            }
        }
        finally {
            ReflectionContextState.clear(context);
            context.remove("conversion.property.fullName");
            context.remove("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
        }
    }

    public String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr) {
        try {
            if (expr == null) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if (this.defaultType != null) {
                Object object = this.findValue(expr, this.defaultType);
                return object;
            }
            Object value = this.ognlUtil.getValue(expr, this.context, this.root);
            if (value != null) {
                Object object = value;
                return object;
            }
            this.checkForInvalidProperties(expr);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            this.checkForInvalidProperties(expr);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr, Class asType) {
        try {
            Object value;
            if (expr == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if ((value = this.ognlUtil.getValue(expr, this.context, this.root, asType)) != null) {
                Object object = value;
                return object;
            }
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    private Object findInContext(String name) {
        return this.getContext().get(name);
    }

    private void checkForInvalidProperties(String expr) {
        if (expr.contains("(") && expr.contains(")")) {
            LOG.warn("Could not find method [" + expr + "]", new String[0]);
        } else if (this.findInContext(expr) == null) {
            LinkedHashSet availableProperties = new LinkedHashSet();
            for (Object o : this.root) {
                if (!(o instanceof ActionSupport) && !o.getClass().getSimpleName().endsWith("Action")) continue;
                try {
                    this.findAvailableProperties(o.getClass(), expr, availableProperties, null);
                }
                catch (IntrospectionException ise) {}
            }
            if (!availableProperties.contains(expr)) {
                LOG.warn("Could not find property [" + expr + "]", new String[0]);
            }
        }
    }

    private void findAvailableProperties(Class c, String expr, Set availableProperties, String parent) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor pd : descriptors = this.ognlUtil.getPropertyDescriptors(c)) {
            Method[] methods;
            String name = pd.getDisplayName();
            if (parent != null && expr.indexOf(".") > -1) {
                name = expr.substring(0, expr.indexOf(".") + 1) + name;
            }
            if (!expr.startsWith(name)) continue;
            availableProperties.add(parent != null ? parent + "." + name : name);
            if (expr.equals(name)) break;
            if (expr.indexOf(".") <= -1) continue;
            String property = expr.substring(expr.indexOf(".") + 1);
            String rawProperty = property.indexOf(".") > -1 ? property.substring(0, property.indexOf(".")) : property;
            String methodToLookFor = "get" + rawProperty.substring(0, 1).toUpperCase() + rawProperty.substring(1);
            for (Method method : methods = pd.getPropertyType().getDeclaredMethods()) {
                if (!method.getName().equals(methodToLookFor)) continue;
                availableProperties.add(name + "." + rawProperty);
                Class<?> returnType = method.getReturnType();
                this.findAvailableProperties(returnType, property, availableProperties, name);
            }
        }
    }

    private void logLookupFailure(String expr, Exception e) {
        String msg = LoggerUtils.format("Caught an exception while evaluating expression '#0' against value stack", expr);
        if (this.devMode && LOG.isWarnEnabled()) {
            LOG.warn(msg, e, new String[0]);
            LOG.warn("NOTE: Previous warning message was issued due to devMode set to true.", new String[0]);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(msg, e, new String[0]);
        }
    }

    public Object peek() {
        return this.root.peek();
    }

    public Object pop() {
        return this.root.pop();
    }

    public void push(Object o) {
        this.root.push(o);
    }

    public void set(String key, Object o) {
        Map<String, Object> setMap = null;
        Object topObj = this.peek();
        if (topObj instanceof Map && ((Map)topObj).get(MAP_IDENTIFIER_KEY) != null) {
            setMap = (Map)topObj;
        } else {
            setMap = new HashMap<String, String>();
            setMap.put(MAP_IDENTIFIER_KEY, "");
            this.push(setMap);
        }
        setMap.put(key, o);
    }

    public int size() {
        return this.root.size();
    }

    private Object readResolve() {
        ActionContext ac = ActionContext.getContext();
        Container cont = ac.getContainer();
        XWorkConverter xworkConverter = cont.getInstance(XWorkConverter.class);
        CompoundRootAccessor accessor = (CompoundRootAccessor)cont.getInstance(PropertyAccessor.class, CompoundRoot.class.getName());
        TextProvider prov = cont.getInstance(TextProvider.class, "system");
        boolean allow = "true".equals(cont.getInstance(String.class, "allowStaticMethodAccess"));
        OgnlValueStack aStack = new OgnlValueStack(xworkConverter, accessor, prov, allow);
        aStack.setOgnlUtil(cont.getInstance(OgnlUtil.class));
        aStack.setRoot(xworkConverter, accessor, this.root, allow);
        return aStack;
    }
}

