/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.impl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.DefaultTextProvider;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ContainerProvider;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.RuntimeConfiguration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.impl.ActionConfigMatcher;
import com.opensymphony.xwork2.config.impl.LocatableConstantFactory;
import com.opensymphony.xwork2.config.impl.NamespaceMatch;
import com.opensymphony.xwork2.config.impl.NamespaceMatcher;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.conversion.ObjectTypeDeterminer;
import com.opensymphony.xwork2.conversion.impl.DefaultObjectTypeDeterminer;
import com.opensymphony.xwork2.conversion.impl.XWorkBasicConverter;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.ognl.OgnlReflectionProvider;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.ognl.OgnlValueStackFactory;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.PatternMatcher;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import ognl.PropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultConfiguration.class);
    protected Map<String, PackageConfig> packageContexts = new LinkedHashMap<String, PackageConfig>();
    protected RuntimeConfiguration runtimeConfiguration;
    protected Container container;
    protected String defaultFrameworkBeanName;
    protected Set<String> loadedFileNames = new TreeSet<String>();
    ObjectFactory objectFactory;

    public DefaultConfiguration() {
        this("xwork");
    }

    public DefaultConfiguration(String defaultBeanName) {
        this.defaultFrameworkBeanName = defaultBeanName;
    }

    @Override
    public PackageConfig getPackageConfig(String name) {
        return this.packageContexts.get(name);
    }

    @Override
    public Set getPackageConfigNames() {
        return this.packageContexts.keySet();
    }

    @Override
    public Map getPackageConfigs() {
        return this.packageContexts;
    }

    @Override
    public Set<String> getLoadedFileNames() {
        return this.loadedFileNames;
    }

    @Override
    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void addPackageConfig(String name, PackageConfig packageContext) {
        PackageConfig check = this.packageContexts.get(name);
        if (check != null) {
            if (check.getLocation() != null && packageContext.getLocation() != null && check.getLocation().equals(packageContext.getLocation())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The package name '" + name + "' is already been loaded by the same location and could be removed: " + packageContext.getLocation(), new String[0]);
                }
            } else {
                throw new ConfigurationException("The package name '" + name + "' at location " + packageContext.getLocation() + " is already been used by another package at location " + check.getLocation(), (Object)packageContext);
            }
        }
        this.packageContexts.put(name, packageContext);
    }

    @Override
    public void destroy() {
        this.packageContexts.clear();
        this.loadedFileNames.clear();
    }

    @Override
    public void rebuildRuntimeConfiguration() {
        this.runtimeConfiguration = this.buildRuntimeConfiguration();
    }

    @Override
    public synchronized void reload(List<ConfigurationProvider> providers) throws ConfigurationException {
        ArrayList<ContainerProvider> contProviders = new ArrayList<ContainerProvider>();
        contProviders.addAll(providers);
        this.reloadContainer(contProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<PackageProvider> reloadContainer(List<ContainerProvider> providers) throws ConfigurationException {
        this.packageContexts.clear();
        this.loadedFileNames.clear();
        ArrayList<PackageProvider> packageProviders = new ArrayList<PackageProvider>();
        ContainerProperties props = new ContainerProperties();
        ContainerBuilder builder = new ContainerBuilder();
        for (ContainerProvider containerProvider : providers) {
            containerProvider.init(this);
            containerProvider.register(builder, props);
        }
        props.setConstants(builder);
        builder.factory(Configuration.class, new Factory<Configuration>(){

            @Override
            public Configuration create(Context context) throws Exception {
                return DefaultConfiguration.this;
            }
        });
        try {
            Container bootstrap = this.createBootstrapContainer();
            this.setContext(bootstrap);
            this.container = builder.create(false);
            this.setContext(this.container);
            this.objectFactory = this.container.getInstance(ObjectFactory.class);
            for (ContainerProvider containerProvider : providers) {
                if (!(containerProvider instanceof PackageProvider)) continue;
                this.container.inject(containerProvider);
                ((PackageProvider)((Object)containerProvider)).loadPackages();
                packageProviders.add((PackageProvider)((Object)containerProvider));
            }
            Set<String> packageProviderNames = this.container.getInstanceNames(PackageProvider.class);
            if (packageProviderNames != null) {
                for (String name : packageProviderNames) {
                    PackageProvider provider = this.container.getInstance(PackageProvider.class, name);
                    provider.init(this);
                    provider.loadPackages();
                    packageProviders.add(provider);
                }
            }
            this.rebuildRuntimeConfiguration();
        }
        finally {
            ActionContext.setContext(null);
        }
        return packageProviders;
    }

    protected ActionContext setContext(Container cont) {
        ValueStack vs = cont.getInstance(ValueStackFactory.class).createValueStack();
        ActionContext context = new ActionContext(vs.getContext());
        ActionContext.setContext(context);
        return context;
    }

    protected Container createBootstrapContainer() {
        ContainerBuilder builder = new ContainerBuilder();
        builder.factory(ObjectFactory.class, Scope.SINGLETON);
        builder.factory(ReflectionProvider.class, OgnlReflectionProvider.class, Scope.SINGLETON);
        builder.factory(ValueStackFactory.class, OgnlValueStackFactory.class, Scope.SINGLETON);
        builder.factory(XWorkConverter.class, Scope.SINGLETON);
        builder.factory(XWorkBasicConverter.class, Scope.SINGLETON);
        builder.factory(TextProvider.class, "system", DefaultTextProvider.class, Scope.SINGLETON);
        builder.factory(ObjectTypeDeterminer.class, DefaultObjectTypeDeterminer.class, Scope.SINGLETON);
        builder.factory(PropertyAccessor.class, CompoundRoot.class.getName(), CompoundRootAccessor.class, Scope.SINGLETON);
        builder.factory(OgnlUtil.class, Scope.SINGLETON);
        builder.constant("devMode", "false");
        return builder.create(true);
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        LinkedHashMap<String, Map<String, ActionConfig>> namespaceActionConfigs = new LinkedHashMap<String, Map<String, ActionConfig>>();
        LinkedHashMap<String, String> namespaceConfigs = new LinkedHashMap<String, String>();
        for (PackageConfig packageConfig : this.packageContexts.values()) {
            if (packageConfig.isAbstract()) continue;
            String namespace = packageConfig.getNamespace();
            LinkedHashMap<String, ActionConfig> configs = (LinkedHashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new LinkedHashMap<String, ActionConfig>();
            }
            Map<String, ActionConfig> actionConfigs = packageConfig.getAllActionConfigs();
            Iterator<String> i$ = actionConfigs.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String actionName = o = i$.next();
                ActionConfig baseConfig = actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageConfig, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
            if (packageConfig.getFullDefaultActionRef() == null) continue;
            namespaceConfigs.put(namespace, packageConfig.getFullDefaultActionRef());
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs, namespaceConfigs);
    }

    private void setDefaultResults(Map<String, ResultConfig> results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        for (Map.Entry<String, ResultConfig> entry : results.entrySet()) {
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(new ResultConfig.Builder(null, resultTypeConfig.getClassName()).build());
        }
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        TreeMap<String, String> params = new TreeMap<String, String>(baseConfig.getParams());
        TreeMap<String, ResultConfig> results = new TreeMap<String, ResultConfig>();
        if (!baseConfig.getPackageName().equals(packageContext.getName()) && this.packageContexts.containsKey(baseConfig.getPackageName())) {
            results.putAll(this.packageContexts.get(baseConfig.getPackageName()).getAllGlobalResults());
        } else {
            results.putAll(packageContext.getAllGlobalResults());
        }
        results.putAll(baseConfig.getResults());
        this.setDefaultResults(results, packageContext);
        ArrayList<InterceptorMapping> interceptors = new ArrayList<InterceptorMapping>(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference(new PackageConfig.Builder(packageContext), defaultInterceptorRefName, new LinkedHashMap(), packageContext.getLocation(), this.objectFactory));
        }
        ActionConfig config = new ActionConfig.Builder(baseConfig).addParams(params).addResultConfigs(results).defaultClassName(packageContext.getDefaultClassRef()).interceptors(interceptors).addExceptionMappings(packageContext.getAllExceptionMappingConfigs()).build();
        return config;
    }

    class ContainerProperties
    extends LocatableProperties {
        private static final long serialVersionUID = -7320625750836896089L;

        ContainerProperties() {
        }

        public Object setProperty(String key, String value) {
            String oldValue = this.getProperty(key);
            if (oldValue != null && !oldValue.equals(value) && !DefaultConfiguration.this.defaultFrameworkBeanName.equals(oldValue)) {
                LOG.info("Overriding property " + key + " - old value: " + oldValue + " new value: " + value, new String[0]);
            }
            return super.setProperty(key, value);
        }

        public void setConstants(ContainerBuilder builder) {
            for (Object keyobj : this.keySet()) {
                String key = (String)keyobj;
                builder.factory(String.class, key, new LocatableConstantFactory<String>(this.getProperty(key), this.getPropertyLocation(key)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map<String, Map<String, ActionConfig>> namespaceActionConfigs;
        private Map<String, ActionConfigMatcher> namespaceActionConfigMatchers;
        private NamespaceMatcher namespaceMatcher;
        private Map<String, String> namespaceConfigs;

        public RuntimeConfigurationImpl(Map<String, Map<String, ActionConfig>> namespaceActionConfigs, Map<String, String> namespaceConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
            this.namespaceConfigs = namespaceConfigs;
            PatternMatcher matcher = DefaultConfiguration.this.container.getInstance(PatternMatcher.class);
            this.namespaceActionConfigMatchers = new LinkedHashMap<String, ActionConfigMatcher>();
            this.namespaceMatcher = new NamespaceMatcher(matcher, namespaceActionConfigs.keySet());
            for (String ns : namespaceActionConfigs.keySet()) {
                this.namespaceActionConfigMatchers.put(ns, new ActionConfigMatcher(matcher, namespaceActionConfigs.get(ns), true));
            }
        }

        @Override
        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            NamespaceMatch match;
            ActionConfig config = this.findActionConfigInNamespace(namespace, name);
            if (config == null && (match = (NamespaceMatch)this.namespaceMatcher.match(namespace)) != null && (config = this.findActionConfigInNamespace(match.getPattern(), name)) != null) {
                config = new ActionConfig.Builder(config).addParams(match.getVariables()).build();
            }
            if (config == null && namespace != null && !namespace.trim().equals("")) {
                config = this.findActionConfigInNamespace("", name);
            }
            return config;
        }

        ActionConfig findActionConfigInNamespace(String namespace, String name) {
            String defaultActionRef;
            Map<String, ActionConfig> actions;
            ActionConfig config = null;
            if (namespace == null) {
                namespace = "";
            }
            if ((actions = this.namespaceActionConfigs.get(namespace)) != null && (config = actions.get(name)) == null && (config = (ActionConfig)this.namespaceActionConfigMatchers.get(namespace).match(name)) == null && (defaultActionRef = this.namespaceConfigs.get(namespace)) != null) {
                config = actions.get(defaultActionRef);
            }
            return config;
        }

        @Override
        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            for (String namespace : this.namespaceActionConfigs.keySet()) {
                Map<String, ActionConfig> actionConfigs = this.namespaceActionConfigs.get(namespace);
                for (String s : actionConfigs.keySet()) {
                    buff.append(namespace).append("/").append(s).append("\n");
                }
            }
            return buff.toString();
        }
    }
}

