/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.jmx.impl;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.jmx.NotificationBroadcasterProxyImpl;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.UnrecognizedComponentException;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.ManagementException;
import javax.slee.management.NotificationSource;
import javax.slee.management.UnrecognizedNotificationSourceException;

public class TraceMBeanProxyImpl
extends NotificationBroadcasterProxyImpl
implements TraceMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public TraceMBeanProxyImpl(ObjectName objectName, MBeanFacade mBeanFacade) {
        super(objectName, mBeanFacade);
        this.objName = objectName;
        this.facade = mBeanFacade;
    }

    public String[] getTracersUsed(NotificationSource notificationSource) throws NullPointerException, UnrecognizedNotificationSourceException, ManagementException, TCKTestErrorException {
        try {
            return (String[])this.facade.invoke(this.objName, "getTracersUsed", new Object[]{notificationSource}, new String[]{"javax.slee.management.NotificationSource"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedNotificationSourceException) {
                throw (UnrecognizedNotificationSourceException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void setTraceLevel(NotificationSource notificationSource, String string, TraceLevel traceLevel) throws NullPointerException, UnrecognizedNotificationSourceException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "setTraceLevel", new Object[]{notificationSource, string, traceLevel}, new String[]{"javax.slee.management.NotificationSource", "java.lang.String", "javax.slee.facilities.TraceLevel"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedNotificationSourceException) {
                throw (UnrecognizedNotificationSourceException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public String[] getTracersSet(NotificationSource notificationSource) throws NullPointerException, UnrecognizedNotificationSourceException, ManagementException, TCKTestErrorException {
        try {
            return (String[])this.facade.invoke(this.objName, "getTracersSet", new Object[]{notificationSource}, new String[]{"javax.slee.management.NotificationSource"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedNotificationSourceException) {
                throw (UnrecognizedNotificationSourceException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void setTraceLevel(ComponentID componentID, Level level) throws NullPointerException, UnrecognizedComponentException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "setTraceLevel", new Object[]{componentID, level}, new String[]{"javax.slee.ComponentID", "javax.slee.facilities.Level"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedComponentException) {
                throw (UnrecognizedComponentException)exception;
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public TraceLevel getTraceLevel(NotificationSource notificationSource, String string) throws NullPointerException, InvalidArgumentException, UnrecognizedNotificationSourceException, ManagementException, TCKTestErrorException {
        try {
            return (TraceLevel)this.facade.invoke(this.objName, "getTraceLevel", new Object[]{notificationSource, string}, new String[]{"javax.slee.management.NotificationSource", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof UnrecognizedNotificationSourceException) {
                throw (UnrecognizedNotificationSourceException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void unsetTraceLevel(NotificationSource notificationSource, String string) throws NullPointerException, UnrecognizedNotificationSourceException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "unsetTraceLevel", new Object[]{notificationSource, string}, new String[]{"javax.slee.management.NotificationSource", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedNotificationSourceException) {
                throw (UnrecognizedNotificationSourceException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public Level getTraceLevel(ComponentID componentID) throws NullPointerException, UnrecognizedComponentException, ManagementException, TCKTestErrorException {
        try {
            return (Level)this.facade.invoke(this.objName, "getTraceLevel", new Object[]{componentID}, new String[]{"javax.slee.ComponentID"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedComponentException) {
                throw (UnrecognizedComponentException)exception;
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }
}

