/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.jmx.impl;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.jmx.NotificationBroadcasterProxyImpl;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.SbbUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.InvalidStateException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ManagementException;

public class SbbUsageMBeanProxyImpl
extends NotificationBroadcasterProxyImpl
implements SbbUsageMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public SbbUsageMBeanProxyImpl(ObjectName objectName, MBeanFacade mBeanFacade) {
        super(objectName, mBeanFacade);
        this.objName = objectName;
        this.facade = mBeanFacade;
    }

    public SbbID getSbb() throws ManagementException, TCKTestErrorException {
        try {
            return (SbbID)this.facade.invoke(this.objName, "getSbb", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void close() throws InvalidStateException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "close", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof InvalidStateException) {
                throw (InvalidStateException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public ServiceID getService() throws ManagementException, TCKTestErrorException {
        try {
            return (ServiceID)this.facade.invoke(this.objName, "getService", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public String getUsageParameterSet() throws ManagementException, TCKTestErrorException {
        try {
            return (String)this.facade.invoke(this.objName, "getUsageParameterSet", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void resetAllUsageParameters() throws ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "resetAllUsageParameters", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }
}

