/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils;

import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.UnrecognizedComponentException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileTableAlreadyExistsException;
import javax.slee.profile.UnrecognizedProfileSpecificationException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class ProfileUtils {
    private SleeTCKTestUtils utils;
    private ProfileProvisioningMBeanProxy profileProvisioningProxy;
    private ProfileSpecificationID stdAddressProfileSpecID;

    public ProfileUtils(SleeTCKTestUtils sleeTCKTestUtils) {
        this.utils = sleeTCKTestUtils;
    }

    public ProfileProvisioningMBeanProxy getProfileProvisioningProxy() throws TCKTestErrorException {
        if (this.profileProvisioningProxy == null) {
            ObjectName objectName = this.utils.getSleeManagementMBeanProxy().getProfileProvisioningMBean();
            this.profileProvisioningProxy = this.utils.getMBeanProxyFactory().createProfileProvisioningMBeanProxy(objectName);
        }
        return this.profileProvisioningProxy;
    }

    public void createStandardAddressProfileTable(String string) throws TCKTestErrorException, ManagementException, UnrecognizedProfileSpecificationException, InvalidArgumentException, ProfileTableAlreadyExistsException, UnrecognizedComponentException {
        String string2 = "tck.";
        if (!string.startsWith(string2)) {
            throw new TCKTestErrorException("Standard address profiles created by the tck must start with the \"" + string2 + "\" prefix");
        }
        this.getProfileProvisioningProxy().createProfileTable(this.getStdAddressProfileSpecID(), string);
    }

    public void removeProfileTable(String string) throws TCKTestErrorException, UnrecognizedProfileTableNameException, ManagementException {
        this.getProfileProvisioningProxy().removeProfileTable(string);
    }

    public ProfileSpecificationID getStdAddressProfileSpecID() throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        if (this.stdAddressProfileSpecID == null) {
            this.stdAddressProfileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("AddressProfileSpec", "javax.slee", "1.0");
            if (this.stdAddressProfileSpecID == null) {
                throw new TCKTestErrorException("Standard address profile specification not found");
            }
        }
        return this.stdAddressProfileSpecID;
    }

    public List getTCKStdAddressProfileTables() throws TCKTestErrorException, ManagementException, UnrecognizedProfileTableNameException, UnrecognizedComponentException {
        Vector<String> vector = new Vector<String>();
        String string = "tck.";
        for (String string2 : this.getProfileProvisioningProxy().getProfileTables()) {
            ProfileSpecificationID profileSpecificationID = this.getProfileProvisioningProxy().getProfileSpecification(string2);
            if (!profileSpecificationID.equals((Object)this.getStdAddressProfileSpecID()) || !string2.startsWith(string)) continue;
            vector.addElement(string2);
        }
        return vector;
    }
}

