/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.util.Future;

public class FutureResult {
    private Future result;
    private Logable log;

    public FutureResult(Logable logable) {
        this.log = logable;
        this.result = new Future();
    }

    public void setPassed() {
        this.setIfEmpty(TCKTestResult.passed());
    }

    public void setFailed(int n, String string) {
        this.setIfEmpty(TCKTestResult.failed(n, string));
    }

    public void setFailed(TCKTestFailureException tCKTestFailureException) {
        this.setIfEmpty(TCKTestResult.failed(tCKTestFailureException));
    }

    public void setError(String string, Throwable throwable) {
        this.setIfEmpty(TCKTestResult.error(string, throwable));
    }

    public void setError(String string) {
        this.setIfEmpty(TCKTestResult.error(string));
    }

    public void setError(Throwable throwable) {
        this.setIfEmpty(TCKTestResult.error(throwable));
    }

    public void setResult(TCKTestResult tCKTestResult) {
        this.setIfEmpty(tCKTestResult);
    }

    public boolean isSet() {
        return this.result.isSet();
    }

    public TCKTestResult waitForResult(long l, String string) {
        return this.waitForResultImpl(l, false, string, -1);
    }

    public TCKTestResult waitForResultOrFail(long l, String string, int n) {
        return this.waitForResultImpl(l, true, string, n);
    }

    public TCKTestResult waitForResult(long l) throws Future.TimeoutException {
        return (TCKTestResult)this.result.getValue(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult waitForResultImpl(long l, boolean bl, String string, int n) {
        TCKTestResult tCKTestResult = null;
        try {
            tCKTestResult = this.waitForResult(l);
        }
        catch (Future.TimeoutException timeoutException) {
            String string2 = "Timed out waiting for condition: " + string;
            tCKTestResult = bl ? TCKTestResult.failed(n, string2) : TCKTestResult.error(string2);
            Future future = this.result;
            synchronized (future) {
                if (this.result.isSet()) {
                    this.log.warning("Dropping result set by another thread immediately after the timeout: " + this.result.getValue());
                }
                this.result.setValue(tCKTestResult);
            }
        }
        return tCKTestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIfEmpty(TCKTestResult tCKTestResult) {
        Future future = this.result;
        synchronized (future) {
            if (!this.result.isSet()) {
                this.result.setValue(tCKTestResult);
            } else {
                this.log.warning("Attempt to set result for FutureResult after a result has already been set. Ignoring suggested new result: " + tCKTestResult.toString());
            }
        }
    }
}

