/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.types;

import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import javax.management.Notification;

public class Test2154Test
extends GenericUsageTest {
    private TCKActivityID activityID;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListener;
    private GenericUsageMBeanProxy sbbUsageMBeanProxy;
    private long expectedCounterValue;

    public TCKTestResult run() throws Exception {
        this.activityID = this.utils().getResourceInterface().createActivity("Test2154Test-Activity");
        this.expectedCounterValue = 0L;
        this.testIncrements(new long[]{Long.MIN_VALUE});
        this.testIncrements(new long[]{-9223372036854775807L, 0x7FFFFFFFFFFFFFFEL});
        this.testIncrements(new long[]{Long.MAX_VALUE});
        this.testIncrements(new long[]{1L, 10L, -10L, 0L, -1L});
        this.testIncrements(new long[]{4L});
        this.testIncrements(new long[]{-4L});
        this.testIncrements(new long[]{-1L, 3L});
        this.testIncrements(new long[]{1L, -3L});
        this.testIncrements(new long[]{10L, 5L});
        this.testIncrements(new long[]{10L, -5L});
        this.testIncrements(new long[]{-10L, 5L});
        this.testIncrements(new long[]{-10L, -5L});
        this.getLog().info("All checks passed");
        return TCKTestResult.passed();
    }

    private void testIncrements(long[] increments) throws Exception {
        this.resetCounter();
        this.auditCounterValue();
        for (int i = 0; i < increments.length; ++i) {
            long increment = increments[i];
            this.doUpdateAndWait(increment);
            this.auditCounterValue();
        }
    }

    private void resetCounter() throws Exception {
        this.sbbUsageMBeanProxy.getFirstCount(true);
        this.expectedCounterValue = 0L;
    }

    private void doUpdateAndWait(long increment) throws Exception {
        this.getLog().fine("Sending update instructions to the SBB via an event. Increment value: " + increment);
        GenericUsageSbbInstructions instructions = new GenericUsageSbbInstructions(null);
        instructions.addFirstCountIncrement(increment);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructions.toExported(), this.activityID, null);
        this.getLog().fine("Waiting for a reply from the SBB");
        this.resourceListener.nextMessage();
        this.getLog().fine("Received reply from SBB. Waiting for notification of update");
        Notification usageNotification = this.notificationListener.nextNotification();
        this.getLog().fine("Received notification of update: " + usageNotification);
        this.expectedCounterValue += increment;
    }

    private void auditCounterValue() throws Exception {
        long actualCounterValue = this.sbbUsageMBeanProxy.getFirstCount(false);
        this.getLog().info("Auditing counter value. Expected value:" + this.expectedCounterValue);
        if (actualCounterValue != this.expectedCounterValue) {
            throw new TCKTestFailureException(2154, "SbbUsageMBean.getFirstCount(false) returned an invalid counter value. Expected=" + this.expectedCounterValue + "; counter value returned=" + actualCounterValue);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.sbbUsageMBeanProxy = this.getGenericUsageMBeanLookup().getUnnamedGenericUsageMBeanProxy();
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.sbbUsageMBeanProxy.addNotificationListener(this.notificationListener, null, null);
    }

    public void tearDown() throws Exception {
        if (this.notificationListener != null) {
            try {
                this.sbbUsageMBeanProxy.removeNotificationListener(this.notificationListener);
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        this.sbbUsageMBeanProxy = null;
        super.tearDown();
    }
}

