/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.profiles;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.profiles.BaseProfileTest;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileTableUsageMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;

public class Test1111076Test
extends BaseProfileTest {
    public static final String PROFILE_TABLE_NAME = "Test1111076ProfileTable";
    public static final String PROFILE_NAME = "Test1111076Profile";
    private static boolean DEFAULT_MESSAGE = true;
    private static boolean NAMED_MESSAGE = false;
    private boolean messageAReceived = false;
    private boolean messageBReceived = false;
    private FutureResult result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils().getLog());
        try {
            this.createProfileTable(PROFILE_TABLE_NAME);
            this.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            this.createNamedParameterSet(PROFILE_TABLE_NAME);
            TCKResourceTestInterface resource = this.utils().getResourceInterface();
            TCKActivityID activityID = resource.createActivity(this.getClass().getName());
            String message = new String("Default");
            this.getLog().fine("About to fire default usage parameter update request to the SBB");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
            message = new String("Named");
            this.getLog().fine("About to fire named usage parameter update request to SBB");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
            this.getLog().fine("Waiting for result");
            TCKTestResult tCKTestResult = this.result.waitForResult(5000L);
            return tCKTestResult;
        }
        finally {
            this.removeNamedParameterSet(PROFILE_TABLE_NAME);
            this.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            this.removeProfileTable(PROFILE_TABLE_NAME);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setResourceListener(new TCKResourceListenerImpl());
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1111076Test.this.utils().getLog().fine("Received message from SBB: " + message.getMessage());
            HashMap map = (HashMap)message.getMessage();
            Integer id = (Integer)map.get("ID");
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Msg");
            if (msgString.equals("Default")) {
                this.handleMessage(id, DEFAULT_MESSAGE);
                this.maybeFinished(DEFAULT_MESSAGE);
            } else if (msgString.equals("Named")) {
                this.handleMessage(id, NAMED_MESSAGE);
                this.maybeFinished(NAMED_MESSAGE);
            } else {
                String err = "Received malformed messages from SBB.";
                Test1111076Test.this.utils().getLog().error(err);
                Test1111076Test.this.result.setError(err);
            }
        }

        private void handleMessage(Integer id, boolean messageType) {
            try {
                ObjectName profileTableUsageMBeanName = Test1111076Test.this.profileProxy.getProfileTableUsageMBean(Test1111076Test.PROFILE_TABLE_NAME);
                ProfileTableUsageMBeanProxy p = Test1111076Test.this.utils().getMBeanProxyFactory().createProfileTableUsageMBeanProxy(profileTableUsageMBeanName);
                ObjectName usageMBeanName = messageType == DEFAULT_MESSAGE ? p.getUsageMBean() : p.getUsageMBean(p.getUsageParameterSets()[0]);
                UsageMBeanProxyImpl u = new UsageMBeanProxyImpl(usageMBeanName, Test1111076Test.this.utils().getMBeanFacade());
                long stats = u.getFirstCount(false);
                if (stats != 1L) {
                    Test1111076Test.this.result.setFailed(id == null ? 1111076 : id, "Expected usage parameter to have value 1, but got " + stats);
                }
            }
            catch (Exception e) {
                Test1111076Test.this.utils().getLog().error(e);
                Test1111076Test.this.result.setError(e);
                return;
            }
        }

        private synchronized void maybeFinished(boolean messageType) {
            if (messageType == DEFAULT_MESSAGE) {
                Test1111076Test.this.messageAReceived = true;
            } else if (messageType == NAMED_MESSAGE) {
                Test1111076Test.this.messageBReceived = true;
            }
            if (Test1111076Test.this.messageAReceived && Test1111076Test.this.messageBReceived) {
                Test1111076Test.this.result.setPassed();
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1111076Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1111076Test.this.utils().getLog().warning(e);
            Test1111076Test.this.result.setError(e);
        }
    }
}

