/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.common;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageParameterInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.facilities.Level;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public abstract class GenericUsageSbb
extends BaseTCKSbb {
    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            GenericUsageSbbInstructions instructions = GenericUsageSbbInstructions.fromExported(event.getMessage());
            this.doUpdates(instructions);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void doUpdates(GenericUsageSbbInstructions instructions) {
        try {
            int i;
            long[] values;
            GenericUsageParameterInterface usageParameterInterface;
            String parameterSetName = instructions.getParameterSetName();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): received instructions: " + instructions, null);
            GenericUsageParameterInterface genericUsageParameterInterface = usageParameterInterface = parameterSetName == null ? this.getDefaultSbbUsageParameterSet() : this.getSbbUsageParameterSet(parameterSetName);
            if (instructions.getFirstCountIncrements() != null) {
                values = instructions.getFirstCountIncrements();
                for (i = 0; i < values.length; ++i) {
                    TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): incrementing FirstCount by " + values[i], null);
                    usageParameterInterface.incrementFirstCount(values[i]);
                }
            }
            if (instructions.getSecondCountIncrements() != null) {
                values = instructions.getSecondCountIncrements();
                for (i = 0; i < values.length; ++i) {
                    TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): incrementing SecondCount by " + values[i], null);
                    usageParameterInterface.incrementSecondCount(values[i]);
                }
            }
            if (instructions.getTimeBetweenNewConnectionsSamples() != null) {
                values = instructions.getTimeBetweenNewConnectionsSamples();
                for (i = 0; i < values.length; ++i) {
                    TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): adding TimeBetweenNewConnections sample of " + values[i], null);
                    usageParameterInterface.sampleTimeBetweenNewConnections(values[i]);
                }
            }
            if (instructions.getTimeBetweenErrorsSamples() != null) {
                values = instructions.getTimeBetweenErrorsSamples();
                for (i = 0; i < values.length; ++i) {
                    TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): adding TimeBetweenErrors sample of " + values[i], null);
                    usageParameterInterface.sampleTimeBetweenErrors(values[i]);
                }
            }
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "doUpdates(): replying to test", null);
            TCKSbbUtils.getResourceInterface().sendSbbMessage(instructions.toExported());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract GenericUsageParameterInterface getDefaultSbbUsageParameterSet();

    public abstract GenericUsageParameterInterface getSbbUsageParameterSet(String var1) throws UnrecognizedUsageParameterSetNameException;
}

