/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.Test2508ChildSbbLocalObject;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.RolledBackContext;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.Level;

public abstract class Test2508Sbb
extends BaseTCKSbb {
    public void sbbRolledBack(RolledBackContext context) {
        this.createTraceSafe(Level.INFO, "Test2508Sbb:sbbRolledBack()");
        this.sendSbbMessageSafe("SBB_ROLLED_BACK_PARENT");
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Test2508Sbb:sbbRolledBack().exception:" + exception);
        if (exception instanceof RuntimeException && exception.getMessage().equals("Test2508RuntimeException")) {
            this.createTraceSafe(Level.INFO, "sbbExceptionThrown was invoked on a parent SBB with the RuntimeException thrown from a local interface method invoked on a child SBB");
            this.sendSbbMessageSafe("SBB_EXCEPTION_THROWN_PARENT");
        } else {
            TCKSbbUtils.handleException(new TCKTestErrorException("sbbExceptionThrown() invoked for an unexpected exception. event=" + event + ";aci=" + aci, exception));
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        this.createTraceSafe(Level.INFO, "Test2508Sbb:onTCKResourceEventX1()");
        Test2508ChildSbbLocalObject child = null;
        try {
            this.createTraceSafe(Level.FINE, "Test2508Sbb:onTCKResourceEventX1():creating child relation");
            child = (Test2508ChildSbbLocalObject)this.getChildRelation().create();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
        try {
            this.createTraceSafe(Level.FINE, "Test2508Sbb:onTCKResourceEventX1():calling local interface method throwRuntimeException() on child");
            child.throwRuntimeException();
            TCKSbbUtils.handleException(new TCKTestErrorException("An invocation of an SBB local interface method on a child SBB failed to throw the expected TransactionRolledbackLocalException"));
            return;
        }
        catch (TransactionRolledbackLocalException e) {
            this.createTraceSafe(Level.INFO, "Caught expected TransactionRolledbackLocalException from invocation of child SBB local interface method.");
            this.sendSbbMessageSafe("PARENT_CALLED_CHILD");
            return;
        }
    }

    private void sendSbbMessageSafe(String message) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(message);
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
    }

    public abstract ChildRelation getChildRelation();
}

