/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.StatusUtil;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109270ResourceAdaptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class Test1109270MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    private Test1109270ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;

    public Test1109270MessageListener(Test1109270ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Object message) throws RemoteException {
        TransactionManager txManager = null;
        try {
            int status;
            Transaction txn;
            try {
                txManager = this.ra.getTransactionManager();
            }
            catch (NamingException e) {
                this.msgSender.sendError("Could not look up transaction manager.", e);
                boolean bl = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e2) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e2);
                }
                return bl;
            }
            try {
                txn = txManager.getTransaction();
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109286, "Exception when calling txManager.getTransaction().", e);
                boolean bl = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e2) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e2);
                }
                return bl;
            }
            if (txn != null) {
                this.msgSender.sendFailure(1109286, "The current thread was not yet associated with any TXN thus TXNManager.getTransaction() should have returned 'null'.");
                boolean e = true;
                return e;
            }
            try {
                txManager.begin();
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109270, "Exception occurred when calling TXNManager.begin() to create a new TXN.");
                boolean e2 = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e22) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e22);
                }
                return e2;
            }
            try {
                txn = txManager.getTransaction();
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109286, "Exception occured while calling getTransaction().", e);
                boolean e2 = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e23) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e23);
                }
                return e2;
            }
            if (txn == null) {
                this.msgSender.sendFailure(1109286, "TXNManager.getTransaction() returned 'null' though previously a new TXN had been started with TXNManager.begin().");
            }
            this.msgSender.sendLogMsg("TXNManager.getTransaction() returned current TXN as expected.");
            try {
                status = txManager.getStatus();
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109282, "Exception occurred when calling getStatus().", e);
                boolean e23 = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e2) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e2);
                }
                return e23;
            }
            if (StatusUtil.INVALID.equals(StatusUtil.statusToString(status))) {
                this.msgSender.sendFailure(1109282, "TXNManager.getStatus() returned a value different to the constants defined in the javax.transaction.Status interface.");
                boolean e = true;
                return e;
            }
            this.msgSender.sendLogMsg("TXNManager.getStatus() returned current status of TXN: " + status);
            try {
                txManager.commit();
                this.msgSender.sendLogMsg("commit() returned successfully.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109274, "Exception occurred when calling TXNManager.commit().", e);
                boolean e2 = true;
                try {
                    if (txManager != null && txManager.getTransaction() != null) {
                        txManager.getTransaction().rollback();
                    }
                }
                catch (Exception e24) {
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e24);
                }
                return e2;
            }
            if (null != txManager.getTransaction()) {
                this.msgSender.sendFailure(1109348, "There is still a transaction associated with this thread.");
                boolean e = true;
                return e;
            }
            txManager.setRollbackOnly();
            this.msgSender.sendFailure(1109301, "txManager.setRollbackOnly() did not throw an IllegalStateException");
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
        finally {
            try {
                if (txManager != null && txManager.getTransaction() != null) {
                    txManager.getTransaction().rollback();
                }
            }
            catch (Exception e2) {
                this.msgSender.sendLogMsg("Exception occurred when trying to safely cleanup still active TXNs. This is however not the immediate cause of a eventual test failure/error:" + e2);
            }
        }
        return true;
    }
}

