/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109247ResourceAdaptor;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.NamingException;
import javax.slee.transaction.RollbackListener;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.SystemException;

public class Test1109247MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    private Test1109247ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;

    public Test1109247MessageListener(Test1109247ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        SleeTransactionManager txManager = null;
        try {
            Future future = new Future();
            try {
                txManager = this.ra.getTransactionManager();
            }
            catch (NamingException e) {
                this.msgSender.sendError("Could not look up transaction manager.", e);
                return true;
            }
            SleeTransaction txn = txManager.beginSleeTransaction();
            try {
                txManager.asyncRollback(null);
                this.msgSender.sendLogMsg("asyncRollback(null) did not cause any exceptions as expected.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1109347, "Exception occured when calling TXNManager.asyncRollback(null).");
                return true;
            }
            txn = txManager.beginSleeTransaction();
            MyRollbackListener listener = new MyRollbackListener(future);
            txManager.asyncRollback((RollbackListener)listener);
            if (null != txManager.getSleeTransaction()) {
                this.msgSender.sendFailure(1109248, "There is still a transaction associated with this thread.");
                return true;
            }
            try {
                txManager.asyncRollback(null);
                this.msgSender.sendFailure(1109251, "SleeTransactionManager.asyncRollback() did not throw IllegalStateException");
                return true;
            }
            catch (IllegalStateException e) {
                String result;
                this.msgSender.sendLogMsg("SleeTransactionManager.asyncRollback() threw IllegalStateException as expected.");
                try {
                    result = (String)future.getValue(5000L);
                }
                catch (Future.TimeoutException e2) {
                    this.msgSender.sendFailure(1109250, "Timout occured while waiting for the RollbackListener callbacks to be called.", e2);
                    return true;
                }
                if (!"rolledBack".equals(result)) {
                    this.msgSender.sendFailure(1109250, "The RollbackListener's rolledBack() method shoud have been called but instead the " + result + "() method was called.");
                    return true;
                }
                this.msgSender.sendLogMsg("RollbackListener.rolledBack() was called as expected.");
                if (txn.getStatus() != 4) {
                    this.msgSender.sendFailure(1109249, "Transaction status is not Status.STATUS_ROLLEDBACK.");
                    return true;
                }
                this.msgSender.sendLogMsg("At some point after calling asyncRollback() the TXN status was Status.STATUS_ROLLEDBACK as expected.");
                this.msgSender.sendSuccess(1109247, "Test completed successfully.");
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            try {
                if (null != txManager.getSleeTransaction()) {
                    txManager.getSleeTransaction().rollback();
                }
            }
            catch (SystemException e2) {
                this.msgSender.sendLogMsg("Exception occured when trying to safely rollback leftover TXN, this is however not the immediate cause for an eventual failure of the test: " + (Object)((Object)e2));
            }
        }
        return true;
    }

    public class MyRollbackListener
    implements RollbackListener {
        Future future;

        public MyRollbackListener(Future future) {
            this.future = future;
        }

        public void rolledBack() {
            this.future.setValue("rolledBack");
        }

        public void systemException(SystemException se) {
            this.future.setValue("systemException");
        }
    }
}

