/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.transactions.StatusUtil;
import com.opencloud.sleetck.lib.testsuite.transactions.Test1109203ResourceAdaptor;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.slee.transaction.CommitListener;
import javax.slee.transaction.RollbackListener;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class Test1109203MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    private Future future;
    private long blockTimeout;
    private Test1109203ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;

    public Test1109203MessageListener(Test1109203ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        HashMap map = (HashMap)message;
        this.blockTimeout = 2000L;
        if (map.get("Timeout") != null) {
            this.blockTimeout = (Long)map.get("Timeout");
        }
        if (this.testAsyncCommit() && this.testAsyncRollback()) {
            this.msgSender.sendSuccess(1109203, "Test successful.");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testAsyncRollback() {
        txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        txn = null;
        txn = txnManager.beginSleeTransaction();
        txnManager.suspend();
        try {
            txn.asyncRollback(null);
            this.msgSender.sendLogMsg("Asynchronous rollback could be invoked from thread that is not currently associated with the TXN.");
        }
        catch (Exception e) {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
            this.msgSender.sendFailure(1109341, "Asynchronous rollback failed with exception when invoked from thread that is currently not associated with the TXN.", e);
            return false;
        }
        txn = txnManager.beginSleeTransaction();
        txn.asyncRollback(null);
        txn = txnManager.getSleeTransaction();
        if (txn != null) {
            this.msgSender.sendFailure(1109342, "Association with thread should have been cleared before 'asyncRollback()' returned from its call, thus 'null' should have been returned by TransactionManager.getTransaction().");
            return false;
        }
        this.msgSender.sendLogMsg("Association with thread was cleared before 'asyncRollback()' returned from its call as expected.");
        txn = txnManager.beginSleeTransaction();
        status = txn.getStatus();
        txn.asyncRollback(null);
        if (status != 0 && status != 1) {
            this.msgSender.sendFailure(1109210, "TXN asyncRollback() succeeded but status was different from Status.STATUS_ACTIVE or Status.STATUS_MARKED_ROLLBACK.");
            return false;
        }
        this.msgSender.sendLogMsg("TXN asyncRollback() succeeded and status was Status.STATUS_ACTIVE or Status.STATUS_MARKED_ROLLBACK as expected.");
        {
            catch (Exception e) {
                try {
                    if (txn != null) {
                        txn.rollback();
                    }
                }
                catch (Exception ex) {
                    this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
                }
                this.msgSender.sendException(e);
                return false;
            }
        }
        try {
            txn.asyncRollback(null);
            status = txn.getStatus();
            this.msgSender.sendFailure(1109214, "asyncRollback() succeeded though current status can't have been STATUS_ACTIVE or STATUS_MARKED_ROLLBACK. Current status was: " + StatusUtil.statusToString(status));
            return false;
        }
        catch (IllegalStateException e) {
            this.msgSender.sendLogMsg("IllegalStateException thrown as expected: " + e);
            txn = txnManager.beginSleeTransaction();
            this.future = new Future();
            txn.asyncRollback((RollbackListener)new MyRollbackListener());
            try {}
            catch (Future.TimeoutException e) {
                this.msgSender.sendFailure(1109339, "RollbackListener did not receive callback thus the RA test thread timed out.", e);
                return false;
            }
            ** GOTO lbl-1000
            catch (Exception e) {
                this.msgSender.sendFailure(1109214, "Wrong type of exception thrown, expected java.lang.IllegalStateException but caught: ", e);
                return false;
            }
lbl-1000:
            // 1 sources

            {
                rollbackResult = (String)this.future.getValue(this.blockTimeout);
                if ("rolledBack".equals(rollbackResult)) {
                    this.msgSender.sendLogMsg("RollbackListener received TXN rolledBack callback as expected.");
                    return true;
                }
                this.msgSender.sendFailure(1109339, "RollbackListener did not receive TXN rolledBack callback but returned '" + rollbackResult + "' instead.");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testAsyncCommit() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        txn = txnManager.beginSleeTransaction();
        txnManager.suspend();
        try {
            txn.asyncCommit(null);
            this.msgSender.sendLogMsg("Asynchronous commit could be invoked from thread that is currently not associated with the TXN as expected.");
        }
        catch (Exception e) {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
            this.msgSender.sendFailure(1109268, "Asynchronous commit failed with exception when invoked from thread that is currently not associated with the TXN.", e);
            return false;
        }
        txn = txnManager.beginSleeTransaction();
        txn.asyncCommit(null);
        txn = txnManager.getSleeTransaction();
        if (txn != null) {
            this.msgSender.sendFailure(1109203, "Association with thread should have been cleared before 'asyncCommit()' returned from its call, thus 'null' should have been returned by TransactionManager.getTransaction().");
            return false;
        }
        this.msgSender.sendLogMsg("Association with thread was cleared before 'asyncCommit()' returned from its call as expected.");
        txn = txnManager.beginSleeTransaction();
        int status = txn.getStatus();
        txn.asyncCommit(null);
        if (status != 0 && status != 1) {
            this.msgSender.sendFailure(1109202, "TXN asyncCommit() succeeded but status was different from Status.STATUS_ACTIVE or Status.STATUS_MARKED_ROLLBACK.");
            return false;
        }
        this.msgSender.sendLogMsg("TXN asyncCommit() succeeded and status was Status.STATUS_ACTIVE or Status.STATUS_MARKED_ROLLBACK as expected.");
        {
            catch (Exception e) {
                try {
                    if (txn != null) {
                        txn.rollback();
                    }
                }
                catch (Exception ex) {
                    this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                    this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
                }
                this.msgSender.sendException(e);
                return false;
            }
            try {
                txn.asyncCommit(null);
                status = txn.getStatus();
                this.msgSender.sendFailure(1109207, "asyncCommit() succeeded though current status can't have been STATUS_ACTIVE or STATUS_MARKED_ROLLBACK. Current status was: " + StatusUtil.statusToString(status));
                return false;
            }
            catch (IllegalStateException e) {}
            {
                String commitResult;
                this.msgSender.sendLogMsg("IllegalStateException thrown as expected: " + e);
                txn = txnManager.beginSleeTransaction();
                this.future = new Future();
                txn.asyncCommit((CommitListener)new MyCommitListener());
                try {
                    commitResult = (String)this.future.getValue(this.blockTimeout);
                    if (!"committed".equals(commitResult)) {
                        this.msgSender.sendFailure(1109340, "CommitListener did not receive TXN committed callback but returned '" + commitResult + "' instead.");
                        return false;
                    }
                    this.msgSender.sendLogMsg("CommitListener received TXN commit callback as expected.");
                }
                catch (Future.TimeoutException e) {
                    this.msgSender.sendFailure(1109340, "CommitListener did not receive callback thus the RA test thread timed out.", e);
                    return false;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1109207, "Wrong type of exception thrown, expected java.lang.IllegalStateException but caught: ", e);
                    return false;
                }
                txn = txnManager.beginSleeTransaction();
                this.future = new Future();
                txn.setRollbackOnly();
                txn.asyncCommit((CommitListener)new MyCommitListener());
                try {
                    commitResult = (String)this.future.getValue(this.blockTimeout);
                    if ("rolledBack".equals(commitResult)) {
                        this.msgSender.sendLogMsg("CommitListener received TXN rolledBack callback as expected.");
                        return true;
                    }
                    this.msgSender.sendFailure(1109204, "CommitListener did not receive TXN rolledBack callback but returned '" + commitResult + "' instead.");
                    return false;
                }
                catch (Future.TimeoutException e) {
                    this.msgSender.sendFailure(1109204, "CommitListener did not receive callback thus the RA test thread timed out.", e);
                    return false;
                }
            }
        }
    }

    private class MyRollbackListener
    implements RollbackListener {
        private MyRollbackListener() {
        }

        public void rolledBack() {
            Test1109203MessageListener.this.future.setValue("rolledBack");
        }

        public void systemException(SystemException e) {
            Test1109203MessageListener.this.future.setValue("systemException");
        }
    }

    private class MyCommitListener
    implements CommitListener {
        private MyCommitListener() {
        }

        public void committed() {
            Test1109203MessageListener.this.future.setValue("committed");
        }

        public void heuristicMixed(HeuristicMixedException e) {
            Test1109203MessageListener.this.future.setValue("heuristicMixed");
        }

        public void heuristicRollback(HeuristicRollbackException e) {
            Test1109203MessageListener.this.future.setValue("heuristicRollback");
        }

        public void rolledBack(RollbackException e) {
            Test1109203MessageListener.this.future.setValue("rolledBack");
        }

        public void systemException(SystemException e) {
            Test1109203MessageListener.this.future.setValue("systemException");
        }
    }
}

