/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class Test1109011Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "ServiceDUPath";
    private Hashtable register;
    private RMIObjectChannel in;
    private FutureResult futureResult;
    private TCKTestResult exResult;

    public TCKTestResult run() throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1109011InitialActivity");
        this.getLog().fine("Create two root SBBs by firing initial events into SLEE.");
        this.futureResult = new FutureResult(this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "23", activityID, null);
        this.futureResult.waitForResult(this.utils().getTestTimeout());
        this.futureResult = new FutureResult(this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "42", activityID, null);
        this.futureResult.waitForResult(this.utils().getTestTimeout());
        this.getLog().fine("Fire event into SLEE to start tests. Should be received by both Sbbs.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID, null);
        Thread.sleep(this.utils().getTestTimeout());
        if (this.exResult != null) {
            return this.exResult;
        }
        this.getLog().fine("Number of sbb callbacks: " + this.register.size());
        Iterator iter = this.register.values().iterator();
        while (iter.hasNext()) {
            Boolean rolledBack = (Boolean)iter.next();
            if (rolledBack.booleanValue()) continue;
            return TCKTestResult.failed(1109011, "Though the TCKResourceEventX.X2 event handler TXNs are marked for rollback by the sbb code, the sbbRolledBack() method was not called for at least one of the Sbbs.");
        }
        this.getLog().fine("Fire event into SLEE to make Sbb's send back their stringValue CMP fields.");
        this.futureResult = new FutureResult(this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", activityID, null);
        this.futureResult.waitForResult(this.utils().getTestTimeout());
        return TCKTestResult.passed();
    }

    private void onCMPValue(HashMap map) {
        String value = (String)map.get("stringValue");
        if (value != null) {
            this.setIfEmpty(TCKTestResult.failed(1109011, "Changes made in sbbRolledBack() were not undone though sbbRolledBack's TXN was marked for rollback."));
        } else {
            this.getLog().fine("Changes made in sbbRolledBack() were undone as sbbRolledBack's TXN was marked for rollback itself.");
            this.futureResult.setPassed();
        }
    }

    private void onFromRollback(HashMap map) {
        String sbbID = (String)map.get("SbbID");
        Boolean status = (Boolean)this.register.get(sbbID);
        if (status == null) {
            this.setIfEmpty(TCKTestResult.failed(1109011, "Received rollback message for Sbb entity that did not previously send an ACK for receiving an initial event."));
            return;
        }
        if (status.booleanValue()) {
            this.setIfEmpty(TCKTestResult.failed(1109013, "Received more than one rollback message for an Sbb entity."));
            return;
        }
        this.register.put(sbbID, new Boolean(true));
    }

    private void onEventHandler(HashMap map) {
        String sbbID = (String)map.get("SbbID");
        Boolean status = (Boolean)this.register.get(sbbID);
        if (status != null) {
            this.setIfEmpty(TCKTestResult.failed(1109011, "Event handler msg was received twice for the same Sbb entity."));
            return;
        }
        this.register.put(sbbID, new Boolean(false));
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed();
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1109011Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1109011Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1109011Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1109011Test.this.setError(msg, e);
            }

            public boolean handleMessage(Object message) throws RemoteException {
                if (!super.handleMessage(message)) {
                    HashMap map = (HashMap)message;
                    int type = (Integer)map.get("Type");
                    switch (type) {
                        case 1025: {
                            Test1109011Test.this.onEventHandler((HashMap)message);
                            return true;
                        }
                        case 1026: {
                            Test1109011Test.this.onFromRollback((HashMap)message);
                            return true;
                        }
                        case 1027: {
                            Test1109011Test.this.onCMPValue((HashMap)message);
                            return true;
                        }
                    }
                    Test1109011Test.this.getLog().warning("Received message with unrecognized 'Type' field: " + type);
                    return false;
                }
                return true;
            }
        });
        this.register = new Hashtable();
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        super.tearDown();
    }
}

